% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_omega.density.R
\name{ggplot_omega.density}
\alias{ggplot_omega.density}
\title{The density plot of the diagonal of group covariance, Omega, with ggplot2}
\usage{
ggplot_omega.density(
  Gibbs,
  group.select = 1,
  true.val = NA,
  burnin = NA,
  main.title = "Posterior Densities of Omega",
  x.label = "Value",
  y.label = "Density",
  factor_labels = NULL,
  show.offdiag = TRUE
)
}
\arguments{
\item{Gibbs}{Gibbs sample from BCFM}

\item{group.select}{Group/cluster to plot. If not specified, the first group will be used.}

\item{true.val}{True values of Omega, if applicable.}

\item{burnin}{Number of burn-in period. If not specified, the first tenths is used as burn-in.}

\item{main.title}{Main title for the plot. Default is "Posterior Densities of Omega"}

\item{x.label}{X-axis label. Default is "Value"}

\item{y.label}{Y-axis label. Default is "Density"}

\item{factor_labels}{Character vector of factor names. If NULL, defaults to Factor 1, Factor 2, etc.}

\item{show.offdiag}{Show off-diagonal elements. Default is TRUE for any k.}
}
\value{
A ggplot object showing densities of Omega elements
}
\description{
It returns multiple plots of the diagonal of group covariance, Omega using ggplot2 and gridExtra. It returns the result by each factor, different colors representing different factors
}
