% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_shooting_plot.R
\name{get_shooting_plot}
\alias{get_shooting_plot}
\title{Shooting plot}
\usage{
get_shooting_plot(df_stats, team, type_shot, min_att, title, language, 
                         size_summ = 5, size_add = 16)
}
\arguments{
\item{df_stats}{Data frame with the statistics.}

\item{team}{Team.}

\item{type_shot}{Numeric with values 1-2-3: 1 refers to free throws,
2 refers to two point shots and 3 refers to three points shots.}

\item{min_att}{Minimum number of attempts by the player to
be represented in the plot.}

\item{title}{Plot title.}

\item{language}{Language labels. Current options are 'en' for English
and 'es' for Spanish.}

\item{size_summ}{Size of the text summarizing the total shots and the percentage.}

\item{size_add}{Size of the additional axis and legends.}
}
\value{
Graphical device.
}
\description{
This plot represents the number of shots attempted and scored by every 
player of the same team, together with the scoring percentage. 
The players are sortered by percentage.
}
\examples{
\dontrun{
compet <- "ACB"
df <- do_join_games_bio(compet, acb_games_1718, acb_players_1718)

df1 <- do_add_adv_stats(df)

df2 <- do_stats(df1, "Total", "2017-2018", compet, "Regular Season")

get_shooting_plot(df2, "Valencia", 3, 1, paste("Valencia", compet, "2017-2018", sep = " "), "en")
}

}
\author{
Guillermo Vinue
}
