% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildModule.R
\name{BuildModule}
\alias{BuildModule}
\title{BuildModule}
\usage{
BuildModule(object, type, dir = ".", title = "", description = "",
  details = "", author = "", email = "", paras = NULL,
  dataType = NULL)
}
\arguments{
\item{object}{A function that will be made into a module file.}

\item{type}{A string that defines the type of module. Possible module types
are occurrence, covariate, process, model, diagnostic and output.}

\item{dir}{The directory to put the module into (defaults to the
working directory.}

\item{title}{A short description of the module.}

\item{description}{(required) A single string giving a full description of the module.}

\item{details}{(optional) A single string giving details of the module.}

\item{author}{(required) String giving the author(s) name(s)}

\item{email}{(required) String giving the correspondance address for the module.}

\item{paras}{A list of the form 
list(parameterName = 'Parameter description.',
anotherParameter = 'Another descriptions.')
This is required if the module takes non-default arguements}

\item{dataType}{Character vector required for all module types except 'covariate'.
Indicates the types of data that this module works with. Values can be any of
'presence-only', 'presence/absence', 'abundance' or 'proportion'. For a occurrence
model this should indicate the type of data that is retuned and for other modules
should indicate the type of data they will work with. If the module works with
multiple types they can be supplied in a vector, e.g. c('presence-only',
'presence/absence')}
}
\value{
Name of the module. Outputs a file
}
\description{
Turn a function in the namespace into a module.
Will later add functions to upload module to figshare etc.
And add testing that the module name is unique.
}

