context('GetModuleList')

test_that('GetModuleList renew', {
  
   if (!capabilities('libcurl')) skip('skipping as libcurl not supported')  

   modList <- GetModuleList(renew = TRUE)
   
   expect_is(modList, 'list')
   expect_identical(names(modList),
                    c("occurrence", "covariate", "process", "model", "output"))
 
   expect_true('LocalOccurrenceData' %in% modList$occurrence)
   expect_true('LocalRaster' %in% modList$covariate)
   expect_true('NoProcess' %in% modList$process)
   expect_true('LogisticRegression' %in% modList$model)
   expect_true('PrintMap' %in% modList$output)
    
})

test_that('GetModuleList no renew', {
  
   if (!capabilities('libcurl')) skip('skipping as libcurl not supported')  

   modList <- GetModuleList(renew = FALSE)
   
   expect_is(modList, 'list')
   expect_identical(names(modList),
                    c("occurrence", "covariate", "process", "model", "output"))
   
   expect_true('LocalOccurrenceData' %in% modList$occurrence)
   expect_true('LocalRaster' %in% modList$covariate)
   expect_true('NoProcess' %in% modList$process)
   expect_true('LogisticRegression' %in% modList$model)
   expect_true('PrintMap' %in% modList$output)
  
})
