#![cfg_attr(not(test), no_std)]

#[cfg(test)]
extern crate core;

pub use self::arch::*;
pub use self::call::*;
pub use self::data::*;
pub use self::error::*;
pub use self::flag::*;
pub use self::io::*;
pub use self::number::*;
pub use self::scheme::*;

#[cfg(all(any(target_os = "none", target_os = "redox"), target_arch = "arm"))]
#[path="arch/nonredox.rs"]
mod arch;

#[cfg(all(any(target_os = "none", target_os = "redox"), target_arch = "aarch64"))]
#[path="arch/aarch64.rs"]
mod arch;

#[cfg(all(any(target_os = "none", target_os = "redox"), target_arch = "riscv64"))]
#[path="arch/riscv64.rs"]
mod arch;

#[cfg(all(any(target_os = "none", target_os = "redox"), target_arch = "x86"))]
#[path="arch/x86.rs"]
mod arch;

#[cfg(all(any(target_os = "none", target_os = "redox"), target_arch = "x86_64"))]
#[path="arch/x86_64.rs"]
mod arch;

#[cfg(not(any(target_os = "none", target_os = "redox")))]
#[path="arch/nonredox.rs"]
mod arch;


pub mod call;


pub mod data;


pub mod error;


pub mod flag;


pub mod io;


pub mod number;


pub mod scheme;

#[cfg(test)]
mod tests;
