% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zi_aggregate.R
\name{zi_aggregate}
\alias{zi_aggregate}
\title{Aggregate ZCTAs to Three-digit ZCTAs}
\usage{
zi_aggregate(.data, year, extensive = NULL, intensive = NULL,
    intensive_method = "mean", survey, output = "tidy", zcta = NULL,
    key = NULL)
}
\arguments{
\item{.data}{A tidy set of demographic data containing one or more variables
that should be aggregated to three-digit ZCTAs. This data frame or tibble
should contain all five-digit ZCTAs within the three digit ZCTAs that you
plan to use for aggregating data. See Details below for formatting
requirements.}

\item{year}{A four-digit numeric scalar for year. \code{zippeR} currently
supports data for from 2010 to 2022. Different \code{survey} products
are available for different years. See the \code{survey} parameter
for more details.}

\item{extensive}{A character scalar or vector listing all extensive (i.e.
count data) variables you wish to aggregate. These will be summed. For
American Community Survey data, the margin of error will be calculated by
taking the square root of the summed, squared margins of error for each
five-digit ZCTA within a given three-digit ZCTA.}

\item{intensive}{A character scalar or vector listing all intensive (i.e.
ratio, percent, or median data) variables you wish to aggregate. These
will be combined using the approach listed for \code{intensive_method}.}

\item{intensive_method}{A character scalar; either \code{"mean"} (default)
or \code{"median"}. In either case, a weighted approach is used where
total population for each five-digit ZCTA is used to calculate individual
ZCTAs' weights. For American Community Survey Data, this is applied to
the margin of error as well.}

\item{survey}{A character scalar representing the Census product. It can
be either a Decennial Census product (either \code{"sf1"} or \code{"sf3"})
or an American Community Survey product (either \code{"acs1"},
\code{"acs3"}, or \code{"acs5"}). For Decennial Census calls, only the 2010
Census is available. In addition, if a variable cannot be found in \code{"sf1"},
the function will look in \code{"sf3"}. Also note that \code{"acs3"} was
discontinued after 2013.}

\item{output}{A character scalar; one of \code{"tidy"} (long output) or
\code{"wide"} depending on the type of data format you want. If you are
planning to join these data with geometric data, \code{"wide"} is the
strongly encouraged format.}

\item{zcta}{An optional vector of ZCTAs that demographic data are requested
for. If this is \code{NULL}, data will be returned for all ZCTAs. If a
vector is supplied, only data for those requested ZCTAs will be returned.
The vector can be created with \code{zi_get_geometry()}. If
\code{style = "zcta5"}, this vector should be made up of five-digit
\code{GEOID} values. If \code{style = "zcta3"}, this vector should be
made up of three-digital \code{ZCTA3} values.}

\item{key}{A Census API key, which can be obtained at
\url{https://api.census.gov/data/key_signup.html}. This can be omitted if
\code{tidycensus::census_api_key()} has been used to write your key to
your \code{.Renviron} file. You can check whether an API key has been
written to \code{.Renviron} by using \code{Sys.getenv("CENSUS_API_KEY")}.}
}
\value{
A tibble containing all aggregated data requested in either
    \code{"tidy"} or \code{"wide"} format.
}
\description{
This function takes input ZCTA data and aggregates it to three-digit
   areas, which are considerably larger. These regions are sometimes used in
   American health care contexts for publishing geographic identifiers.
}
\examples{
# load sample demographic data
mo22_demos <- zi_mo_pop

  # the above data can be replicated with the following code:
  # zi_get_demographics(year = 2022, variables = c("B01003_001", "B19013_001"),
  #   survey = "acs5")

# load sample geometric data
mo22_zcta3 <- zi_mo_zcta3

  # the above data can be replicated with the following code:
  # zi_get_geometry(year = 2022, style = "zcta3", state = "MO",
  #   method = "intersect")

# aggregate a single variable
zi_aggregate(mo22_demos, year = 2020, extensive = "B01003_001", survey = "acs5",
  zcta = mo22_zcta3$ZCTA3)

\donttest{
# aggregate multiple variables, outputting wide data
zi_aggregate(mo22_demos, year = 2020,
  extensive = "B01003_001", intensive = "B19013_001", survey = "acs5",
  zcta = mo22_zcta3$ZCTA3, output = "wide")
}

}
