% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Predict.msgdm}
\alias{Predict.msgdm}
\title{Predict zeta values for new environmental and distance data}
\usage{
Predict.msgdm(model.msgdm, reg.type, newdata, type = "response")
}
\arguments{
\item{model.msgdm}{A model returned by \code{Zeta.msgdm}. The class of the model depends on the type of regression used in \code{Zeta.msgdm}.}

\item{reg.type}{Type of regression used in \code{Zeta.msgdm}. Options are "\code{glm}" for generalised linear models, "\code{ngls}" for negative linear models, "\code{gam}" for generalised additive models, "\code{scam}" for shape constrained additive models (with monotonic decreasing by default), and "\code{ispline}" for I-spline models (forcing monotonic decreasing), as recommended in generalised dissimilarity modelling by Ferrier \emph{et al}. (2007).}

\item{newdata}{A data frame with the new environmental and distance data. The names of the columns must be the same as the names used in the data frame used in \code{Zeta.msgdm}. For I-splines, the data frame must be generated beforehand from the original data by the function \code{\link{Ispline}}.}

\item{type}{The type of prediction required, as for \code{predict.glm}. The default is on the scale of the response variable; the alternative "link" is on the scale of the linear predictors.}
}
\value{
\code{Predict.msgdm} returns a vector of predicted zeta values.
}
\description{
Predict the zeta values for new environmental and distance data from the models returned by \code{Zeta.msgdm}.
}
\examples{
utils::data(bird.spec.fine)
xy.bird <- bird.spec.fine[1:500,1:2]
data.spec.bird <- bird.spec.fine[1:500,3:192]
utils::data(bird.env.fine)
data.env.bird <- bird.env.fine[1:500,3:9]

zeta.glm <- Zeta.msgdm(data.spec.bird, data.env.bird, sam = 100, order = 3)
newdata <- data.frame(matrix(NA,100,ncol(data.env.bird)))
names(newdata) <- names(data.env.bird)
for(z in 1:100){
  samp <- sample(1:104, 3, replace = FALSE)
  newdata[z,] <- apply(apply(bird.env.fine[501:604,3:9][samp,], 2,
     stats::dist), 2, mean)
}
##rescale the data like during MS-GDM
newdata <- newdata/matrix(rep(zeta.glm$rescale.factor,100),
   100,length(zeta.glm$rescale.factor),byrow=TRUE)
new.zeta.glm <- Predict.msgdm(model.msgdm = zeta.glm$model, reg.type = "glm",
   newdata = newdata)



zeta.ngls <- Zeta.msgdm(data.spec.bird, data.env.bird, sam = 100, order = 3,
   reg.type = "ngls", normalize=TRUE)
newdata <- data.frame(matrix(NA,100,ncol(data.env.bird)))
names(newdata) <- names(data.env.bird)
for(z in 1:100){
  samp <- sample(1:104, 3, replace = FALSE)
  newdata[z,] <- apply(apply(bird.env.fine[501:604,3:9][samp,], 2, stats::dist),
     2, mean)
}
##rescale the data like during MS-GDM
newdata <- newdata/matrix(rep(zeta.ngls$rescale.factor,100),
   100,length(zeta.ngls$rescale.factor),byrow=TRUE)
new.zeta.ngls <- Predict.msgdm(model.msgdm = zeta.ngls$model, reg.type = "ngls",
   newdata = newdata)
}
\references{
Ramsay, J. O. (1988). Monotone regression splines in action. \emph{Statistical Science}, 425-441.

Ferrier, S., Manion, G., Elith, J., & Richardson, K. (2007). Using generalized dissimilarity modelling to analyse and predict patterns of beta diversity in regional biodiversity assessment. \emph{Diversity and Distributions}, 13(3), 252-264.
}
\seealso{
\code{\link{Zeta.msgdm}}
}

