% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode.R
\name{z22_decode}
\alias{z22_decode}
\title{Decode and translate features and categories}
\usage{
z22_decode(codes, feature, lang = c("english", "german"))
}
\arguments{
\item{codes}{A vector of character codes, possibly prefixed with
\code{"cat_"}.}

\item{feature}{A grid feature that the category \code{codes} belong to.}

\item{lang}{Specifies the language of the output description. Can be
either \code{"english"} (default) or \code{"german"}. Note that the
English descriptions are only ad-hoc translations based off the German
originals.}
}
\value{
\code{.data} with category codes decoded to labels.
}
\description{
Replace category codes with their labels.
}
\examples{
# retrieves a the translation of cat codes directly
z22_decode(1, "marital_status")

# recycles codes
z22_decode(c(1, 1, 1), "marital_status")

# undefined codes are returned as NA
z22_decode(c(1, 2, 3), feature = "sex")

# special case: cat_* strings
z22_decode("cat_2", feature = "sex")
}
