% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teamBowlingWicketKindMatch.R
\name{teamBowlingWicketKindMatch}
\alias{teamBowlingWicketKindMatch}
\title{Compute and plot the wicket kinds by bowlers in match}
\usage{
teamBowlingWicketKindMatch(match,theTeam,opposition,plot=TRUE)
}
\arguments{
\item{match}{The match between the teams}

\item{theTeam}{Team for which bowling performance is required}

\item{opposition}{The opposition team}

\item{plot}{If plot= TRUE the dataframe will be plotted else a data frame will be returned}
}
\value{
None or data fame
A data frame with the bowling performance in alll matches against all oppositions
}
\description{
This function computes returns kind of wickets (caught, bowled etc) of bowlers in a match between 2 teams
}
\note{
Maintainer: Tinniam V Ganesh \email{tvganesh.85@gmail.com}
}
\examples{
\dontrun{
#Get the match details
a <- getMatchDetails("England","Pakistan","2006-09-05",dir="../temp")

teamBowlingWicketKindMatch(a,"England","Pakistan",plot=FALSE)
teamBowlingWicketKindMatch(a,"Pakistan","England")
}

}
\author{
Tinniam V Ganesh
}
\references{
\url{http://cricsheet.org/}\cr
\url{https://gigadom.wordpress.com/}
}
\seealso{
\code{\link{teamBowlingWicketMatch}}\cr
\code{\link{teamBowlingWicketRunsMatch}}\cr
\code{\link{teamBowlersVsBatsmenMatch}}\cr
}

