% Generated by roxygen2 (4.0.1): do not edit by hand
\name{yhat.deploy.to.file}
\alias{yhat.deploy.to.file}
\title{Deploy a model to a file that you can then upload via the browser.}
\usage{
yhat.deploy.to.file(model_name)
}
\arguments{
\item{model_name}{name of your model}
}
\description{
This function creates a .yhat file which can be deployed via the browser.
This is useful for larger models (>20 MB).
}
\examples{
yhat.config <- c(
 username = "your username",
 apikey = "your apikey",
 env = "http://cloud.yhathq.com/"
)
iris$Sepal.Width_sq <- iris$Sepal.Width^2
fit <- glm(I(Species)=="virginica" ~ ., data=iris)

model.require <- function() {
 # require("randomForest")
}

model.transform <- function(df) {
 df$Sepal.Width_sq <- df$Sepal.Width^2
 df
}
model.predict <- function(df) {
 data.frame("prediction"=predict(fit, df, type="response"))
}
yhat.deploy.to.file("irisModel")
}
\keyword{deploy}

