\name{yhat-package}
\alias{yhat-package}
\alias{yhat}
\docType{package}
\title{Interpreting Regression Effects}
\description{
  The purpose of this package is to provide methods to interpret multiple linear regression and canonical correlation results including beta weights, structure coefficients, validity coefficients, product measures, relative weights, all-possible-subsets regression, dominance analysis, commonality analysis, and adjusted effect sizes.
}
\details{
\tabular{ll}{
Package: \tab yhat\cr
Type: \tab Package\cr
Version: \tab 2.0-1\cr
Date: \tab 2020-05-25\cr
License: \tab GPL (>= 2)\cr
LazyLoad: \tab yes\cr
}
 
}
\author{Kim Nimon <kim.nimon@gmail.com>, Fred L. Oswald, J. Kyle Roberts}

\references{
  Beaton, A. E. (1973) \emph{Commonality}. (ERIC Document Reproduction
  Service No. ED111829)
  
  Butts, C. T. (2009). \emph{yacca: Yet Another Canonical Correlation
  Analysis Package}. R package version 1.1.
  
  Mood, A. M. (1969) Macro-analysis of the American educational 
  system. \emph{Operations Research}, \bold{17}, 770-784.
  
  Nimon, K., Lewis, M., Kane, R. & Haynes, R. M. (2008) An R package
  to compute commonality coefficients in the multiple regression
  case: An introduction to the package and a practical example. 
  \emph{Behavior Research Methods}, \bold{40}(2), 457-466.

Nimon, K., & Oswald, F. L. (2013). Understanding the results of multiple linear regression: Beyond standardized regression coefficients. \emph{Organizational Research Methods}, \emph{16}, 
650-674.

}
\keyword{package}
\seealso{
    \code{\link{regr}}
    \code{\link{commonalityCoefficients}}
    \code{\link{canonCommonality}}
    \code{\link{calc.yhat}}
    \code{\link{boot.yhat}}
    \code{\link{booteval.yhat}}
    \code{\link{plotCI.yhat}}
    \code{\link{aps}}
    \code{\link{commonality}}
    \code{\link{dominance}}
    \code{\link{dombin}}
    \code{\link{rlw}}
}
