
tau <- c(seq(30, 6 * 30, 30),  # Monthly up to six months
         seq(240, 2 * 365, 60),  # Two months up to two years
         seq(720 + 90, 6 * 365, 90),  # Three months up to six years
         seq(2160 + 120, 20 * 365, 120),  # Four months up to 20 years
         #               seq(20 * 365 + 182, 30 * 365, 182)) / 365 # Six months up to 30 years
         seq(20 * 365 + 182, 30.6 * 365, 182)) / 365

laggap <- tau - dplyr::lag(tau)
leadgap <- dplyr::lead(tau) - tau

ht <- vapply(1:length(tau), function(x) max(laggap[x], leadgap[x], na.rm = TRUE), runif(1))

xgrid_exp <- list(
  xgrid = c(0.0821917808219178, 0.164383561643836, 0.246575342465753, 
            0.328767123287671, 0.410958904109589, 0.493150684931507, 0.657534246575342, 
            0.821917808219178, 0.986301369863014, 1.15068493150685, 1.31506849315068, 
            1.47945205479452, 1.64383561643836, 1.80821917808219, 1.97260273972603, 
            2.21917808219178, 2.46575342465753, 2.71232876712329, 2.95890410958904, 
            3.20547945205479, 3.45205479452055, 3.6986301369863, 3.94520547945205, 
            4.19178082191781, 4.43835616438356, 4.68493150684932, 4.93150684931507, 
            5.17808219178082, 5.42465753424658, 5.67123287671233, 5.91780821917808, 
            6.24657534246575, 6.57534246575342, 6.9041095890411, 7.23287671232877, 
            7.56164383561644, 7.89041095890411, 8.21917808219178, 8.54794520547945, 
            8.87671232876712, 9.20547945205479, 9.53424657534247, 9.86301369863014, 
            10.1917808219178, 10.5205479452055, 10.8493150684932, 11.1780821917808, 
            11.5068493150685, 11.8356164383562, 12.1643835616438, 12.4931506849315, 
            12.8219178082192, 13.1506849315068, 13.4794520547945, 13.8082191780822, 
            14.1369863013699, 14.4657534246575, 14.7945205479452, 15.1232876712329, 
            15.4520547945205, 15.7808219178082, 16.1095890410959, 16.4383561643836, 
            16.7671232876712, 19.0684931506849, 19.3972602739726, 19.7260273972603, 
            20.4986301369863, 20.9972602739726, 21.4958904109589, 21.9945205479452, 
            22.4931506849315, 22.9917808219178, 23.4904109589041, 23.9890410958904, 
            24.4876712328767, 28.9753424657534, 29.4739726027397), 
  hx = c(0.0821917808219178, 
         0.0821917808219178, 0.0821917808219178, 0.0821917808219178, 0.0821917808219178, 
         0.164383561643836, 0.164383561643836, 0.164383561643836, 0.164383561643836, 
         0.164383561643836, 0.164383561643836, 0.164383561643836, 0.164383561643836, 
         0.164383561643836, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.328767123287672, 0.328767123287672, 0.328767123287672, 
         0.328767123287672, 0.328767123287672, 0.328767123287672, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287673, 1.15068493150685, 1.15068493150685, 
         0.328767123287673, 0.772602739726025, 0.772602739726025, 0.498630136986304, 
         0.498630136986304, 0.498630136986304, 0.4986301369863, 0.498630136986304, 
         0.498630136986304, 0.498630136986304, 2.24383561643836, 2.24383561643836, 
         0.498630136986304), 
  qgrid = c(0.0821917808219178, 0.164383561643836, 
            0.246575342465753, 0.328767123287671, 0.410958904109589, 0.493150684931507, 
            0.657534246575342, 0.821917808219178, 0.986301369863014, 1.15068493150685, 
            1.31506849315068, 1.47945205479452, 1.64383561643836, 1.80821917808219, 
            1.97260273972603, 2.21917808219178, 2.46575342465753, 2.71232876712329, 
            2.95890410958904, 3.20547945205479, 3.45205479452055, 3.6986301369863, 
            3.94520547945205, 4.19178082191781, 4.43835616438356, 4.68493150684932, 
            4.93150684931507, 5.17808219178082, 5.42465753424658, 5.67123287671233, 
            5.91780821917808, 6.24657534246575, 6.57534246575342, 6.9041095890411, 
            7.23287671232877, 7.56164383561644, 7.89041095890411, 8.21917808219178, 
            8.54794520547945, 8.87671232876712, 9.20547945205479, 9.53424657534247, 
            9.86301369863014, 10.1917808219178, 10.5205479452055, 10.8493150684932, 
            11.1780821917808, 11.5068493150685, 11.8356164383562, 12.1643835616438, 
            12.4931506849315, 12.8219178082192, 13.1506849315068, 13.4794520547945, 
            13.8082191780822, 14.1369863013699, 14.4657534246575, 14.7945205479452, 
            15.1232876712329, 15.4520547945205, 15.7808219178082, 16.1095890410959, 
            16.4383561643836, 16.7671232876712, 17.0958904109589, 17.4246575342466, 
            17.7534246575342, 18.0821917808219, 18.4109589041096, 18.7397260273973, 
            19.0684931506849, 19.3972602739726, 19.7260273972603, 20.4986301369863, 
            20.9972602739726, 21.4958904109589, 21.9945205479452, 22.4931506849315, 
            22.9917808219178, 23.4904109589041, 23.9890410958904, 24.4876712328767, 
            24.986301369863, 25.4849315068493, 25.9835616438356, 26.4821917808219, 
            26.9808219178082, 27.4794520547945, 27.9780821917808, 28.4767123287671, 
            28.9753424657534, 29.4739726027397), 
  hq = c(0.0821917808219178, 
         0.0821917808219178, 0.0821917808219178, 0.0821917808219178, 0.0821917808219178, 
         0.164383561643836, 0.164383561643836, 0.164383561643836, 0.164383561643836, 
         0.164383561643836, 0.164383561643836, 0.164383561643836, 0.164383561643836, 
         0.164383561643836, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.246575342465754, 0.246575342465754, 0.246575342465754, 
         0.246575342465754, 0.328767123287672, 0.328767123287672, 0.328767123287672, 
         0.328767123287672, 0.328767123287672, 0.328767123287672, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287671, 0.328767123287671, 0.328767123287673, 
         0.328767123287673, 0.328767123287673, 0.328767123287673, 0.328767123287673, 
         0.328767123287673, 0.328767123287673, 0.328767123287673, 0.328767123287673, 
         0.328767123287673, 0.328767123287673, 0.328767123287673, 0.772602739726025, 
         0.772602739726025, 0.498630136986304, 0.498630136986304, 0.498630136986304, 
         0.4986301369863, 0.498630136986304, 0.498630136986304, 0.498630136986304, 
         0.498630136986304, 0.4986301369863, 0.498630136986304, 0.498630136986304, 
         0.4986301369863, 0.498630136986304, 0.498630136986304, 0.498630136986304, 
         0.498630136986304, 0.4986301369863, 0.498630136986304))

test_that("Calculates number of bonds that mature in each qgrid", {
  
  expect_equal(num_points_mat(
    USbonds, 
    0.029, 
    0.029, 
    tau, 
    ht,
    units = 365
  ), 
  c(176, 160, 161, 191, 172, 260, 116, 67, 108, 100, 97, 121, 109, 
    137, 172, 132, 140, 126, 112, 97, 95, 94, 87, 87, 97, 97, 70, 
    28, 14, 28, 37, 29, 42, 40, 28, 42, 56, 42, 70, 84, 56, 62, 42, 
    22, 28, 14, 14, 17, 28, 24, 14, 28, 28, 28, 28, 28, 28, 28, 14, 
    14, 35, 28, 20, 14, 0, 0, 0, 0, 0, 0, 14, 28, 56, 56, 28, 28, 
    42, 28, 28, 14, 14, 14, 0, 0, 0, 0, 0, 0, 0, 0, 14, 14, 0, 0))
  
  expect_equal(
    `names<-`(create_xgrid_hx(
      USbonds, 
      0.029, 
      0.029, 
      tau, 
      ht,
      5,
      units = 365
    ), names(xgrid_exp)), 
    xgrid_exp
  )
  
  expect_equal(
    generate_yield(), 
    sapply(
      seq_len(12)/12, 
      function(time) sapply(
        (1:36)/(36/10), 
        function(maturity) get_yield_at(
          time, maturity)))
  )
  
})
