% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.arff}
\alias{read.arff}
\title{Read an ARFF file}
\usage{
read.arff(file, stringsAsFactors = default.stringsAsFactors())
}
\arguments{
\item{file}{Name of the file to read the data from}

\item{stringsAsFactors}{Logical: should categorical attributes be converted to
factors?}
}
\value{
A \code{data.frame} with some attributes:
\itemize{
\item attributes: a named vector indicating the type of each variable
\item relation: the original \code{@relation} of the dataset
}
}
\description{
Reads a dataset from an ARFF file, parsing each section and
converting the data section into a \code{data.frame}.
}
\examples{

library(yarr)
\donttest{
yeast <- read.arff("yeast.arff")
}
}
