% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conf_mat.R
\name{summary.conf_mat}
\alias{summary.conf_mat}
\title{Summary Statistics for Confusion Matrices}
\usage{
\method{summary}{conf_mat}(
  object,
  prevalence = NULL,
  beta = 1,
  estimator = NULL,
  event_level = yardstick_event_level(),
  ...
)
}
\arguments{
\item{object}{An object of class \code{\link[=conf_mat]{conf_mat()}}.}

\item{prevalence}{A number in \verb{(0, 1)} for the prevalence (i.e.
prior) of the event. If left to the default, the data are used
to derive this value.}

\item{beta}{A numeric value used to weight precision and
recall for \code{\link[=f_meas]{f_meas()}}.}

\item{estimator}{One of: \code{"binary"}, \code{"macro"}, \code{"macro_weighted"},
or \code{"micro"} to specify the type of averaging to be done. \code{"binary"} is
only relevant for the two class case. The other three are general methods
for calculating multiclass metrics. The default will automatically choose
\code{"binary"} or \code{"macro"} based on \code{estimate}.}

\item{event_level}{A single string. Either \code{"first"} or \code{"second"} to specify
which level of \code{truth} to consider as the "event". This argument is only
applicable when \code{estimator = "binary"}. The default uses an
internal helper that generally defaults to \code{"first"}, however, if the
deprecated global option \code{yardstick.event_first} is set, that will be
used instead with a warning.}

\item{...}{Not currently used.}
}
\value{
A tibble containing various classification metrics.
}
\description{
Various statistical summaries of confusion matrices are
produced and returned in a tibble. These include those shown in the help
pages for \code{\link[=sens]{sens()}}, \code{\link[=recall]{recall()}}, and \code{\link[=accuracy]{accuracy()}}, among others.
}
\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result
when computing binary classification metrics. In \code{yardstick}, the default
is to use the \emph{first} level. To alter this, change the argument
\code{event_level} to \code{"second"} to consider the \emph{last} level of the factor the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\examples{
data("two_class_example")

cmat <- conf_mat(two_class_example, truth = "truth", estimate = "predicted")
summary(cmat)
summary(cmat, prevalence = 0.70)

library(dplyr)
library(purrr)
library(tidyr)
data("hpc_cv")

# Compute statistics per resample then summarize
all_metrics <- hpc_cv \%>\%
  group_by(Resample) \%>\%
  conf_mat(obs, pred) \%>\%
  mutate(summary_tbl = map(conf_mat, summary)) \%>\%
  unnest(summary_tbl)

all_metrics \%>\%
  group_by(.metric) \%>\%
  summarise(
    mean = mean(.estimate, na.rm = TRUE),
    sd = sd(.estimate, na.rm = TRUE)
  )


}
\seealso{
\code{\link[=conf_mat]{conf_mat()}}
}
