% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{classified.factor}
\alias{classified.factor}
\title{Create Classified from Factor}
\usage{
\method{classified}{factor}(
  x = character(),
  levels,
  labels,
  exclude = NA,
  ordered = is.ordered(x),
  nmax = NA,
  token = character(0),
  ...
)
}
\arguments{
\item{x}{see \code{\link{factor}}}

\item{levels}{passed to \code{\link{classified.default}}; defaults to \code{levels(x)}}

\item{labels}{passed to \code{\link{classified.default}}; must be same length as levels(after removing values in \code{exclude}) and must not contain duplicates}

\item{exclude}{see \code{\link{factor}}}

\item{ordered}{see \code{\link{factor}}}

\item{nmax}{see \code{\link{factor}}}

\item{token}{informative label for messages}

\item{...}{ignored}
}
\value{
'classified' 'factor'
}
\description{
Creates classified from factor. Uses \code{\link{classified.default}},
but supplies existing levels by default.
}
\examples{
a <- factor(c('c','b','a'))
levels(classified(a))
attr(classified(a), 'codelist')
}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified}()},
\code{\link{desolve.classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}
}
\concept{classified}
