% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classified.R
\name{classified.data.frame}
\alias{classified.data.frame}
\title{Classify Data Frame}
\usage{
\method{classified}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{passed to \code{\link[dplyr]{select}} to limit column scope}
}
\value{
data.frame
}
\description{
Coerces items in data.frame with codelist attribute to 'classified':
a factor with a codelist attribute.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
x \%>\% explicit_guide \%>\% decorations(Age, Race, Heart:glyco)
x \%>\% explicit_guide \%>\% classified \%>\% decorations(Age, Race, Heart:glyco)
x \%>\% explicit_guide \%>\% classified(Heart:glyco) \%>\% decorations(Age, Race, Heart:glyco)
}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.default}()},
\code{\link{classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified.data.frame}()},
\code{\link{unclassified}()}

Other interface: 
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.default}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{classified}
\concept{interface}
\keyword{internal}
