% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decorated.R, R/singularity.R
\name{[.decorated}
\alias{[.decorated}
\title{Subset Decorated}
\usage{
\method{[}{decorated}(x, ..., .promote = getOption("yamlet_promote", TRUE))

\method{[}{decorated}(x, ..., .promote = getOption("yamlet_promote", TRUE))
}
\arguments{
\item{x}{object to subset}

\item{...}{passed to next method}

\item{.promote}{whether to auto-promote plural attributes}
}
\value{
decorated

decorated
}
\description{
Subsets 'decorated', retaining attributes.

Subsets decorated. Calls \code{\link{promote}}
internally to improve ambiguous conditional
attributes where possible.
}
\examples{
a <- as_decorated(as.list(setNames(letters[1:3], LETTERS[1:3])))
attr(a$B, 'label') <- 'foo'
a <- a[1:3]
attributes(a)
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','phenobarb.csv')
x <- file \%>\% decorate
x \%>\% decorations(event, value)

# Subsetting promotes automatically.
x[x$event == 'dose',] \%>\% decorations(event, value)
x[x$event == 'conc',] \%>\% decorations(event, value)
}
\seealso{
Other decorated: 
\code{\link{[<-.decorated}()},
\code{\link{[[.decorated}()},
\code{\link{[[<-.decorated}()},
\code{\link{names<-.decorated}()}

Other promote: 
\code{\link{filter.decorated}()},
\code{\link{promote.default}()},
\code{\link{promote}()},
\code{\link{singularity}()}
}
\concept{decorated}
\concept{promote}
\keyword{internal}
