% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggready.R
\name{ggready.resolved}
\alias{ggready.resolved}
\title{Prepare Resolved Data Frame for GGplot}
\usage{
\method{ggready}{resolved}(x, ..., parse = getOption("ggready_parse", TRUE))
}
\arguments{
\item{x}{object}

\item{...}{passed to \code{\link{append_units}} and \code{\link{resolve}}; may include unquoted column names}

\item{parse}{passed to \code{\link{append_units}}}
}
\value{
ggready
}
\description{
Prepares resolved data.frame for ggplot. Appends
units to label using \code{\link{append_units}}
(passing \code{style = 'plotmath'} if \code{parse}
is true, else \code{style = 'plain'}).
Enforces classes 'decorated','resolved', and  'ggready'.
Unlike \code{\link{ggready.decorated}}, the
method for class resolved does NOT call resolve(),
and so does not second-guess any particular
resolutions you may have already made.
}
\examples{
example(ggready)
}
\seealso{
Other ggready: 
\code{\link{ggplot.ggready}()},
\code{\link{ggplot_build.ggready_ggplot}()},
\code{\link{ggready.data.frame}()},
\code{\link{ggready.decorated}()},
\code{\link{ggready}()},
\code{\link{print.ggready_ggplot}()}
}
\concept{ggready}
\keyword{internal}
