% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate.data.frame}
\alias{decorate.data.frame}
\title{Decorate Data Frame}
\usage{
\method{decorate}{data.frame}(x, meta = NULL, coerce = getOption("yamlet_coerce", FALSE), ...)
}
\arguments{
\item{x}{data.frame}

\item{meta}{file path for corresponding yaml metadata, or a yamlet; an attempt will be made to guess the file path if x has a 'source' attribute}

\item{coerce}{whether to coerce to factor where guide is a list}

\item{...}{passed to \code{\link{decorate.list}}}
}
\value{
data.frame
}
\description{
Decorates a data.frame. Expects metadata with labels and guides,
where guides are units, factor levels and labels (codes, decodes), or
datetime formatting strings. For guides with length > 1, the corresponding
data element may optionally be coerced to factor.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
meta <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
a <- decorate(as.csv(file))
b <- decorate(as.csv(file), meta = as_yamlet(meta))
c <- decorate(as.csv(file), meta = meta)
d <- decorate(as.csv(file), meta = file)
e <- decorate(as.csv(file), coerce = TRUE)

# Most import methods are equivalent.
identical(a, b)
identical(a, c)
identical(a, d)
identical(a, e)
}
\seealso{
decorate.list

Other decorate: 
\code{\link{decorate.character}()},
\code{\link{decorate.list}()},
\code{\link{decorate}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations}()}
}
\concept{decorate}
