% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module2_estimation.R
\name{estimation}
\alias{estimate_bayesian}
\alias{estimate_check_input}
\alias{estimate_mle}
\alias{estimation}
\title{Estimation of 3PL Model}
\usage{
estimate_mle(u, t = NULL, a = NULL, b = NULL, c = NULL, iter = 20,
  conv = 0.005, method = c("jmle", "mmle"), bound_t = 3.5, bound_a = 2,
  bound_b = 3.5, bound_c = 0.25, mmle_mu = 0, mmle_sig = 1,
  scale = c("none", "theta", "b"), scale_mean = 0, scale_sd = 1,
  debug = FALSE)

estimate_bayesian(u, t = NULL, a = NULL, b = NULL, c = NULL,
  method = c("map", "eap"), iter = 20, conv = 0.005, bound_t = 3.5,
  bound_a = 2, bound_b = 3.5, bound_c = 0.25, scale = c("none", "theta",
  "b"), scale_mean = 0, scale_sd = 1, t_mu = 0, t_sig = 1, a_mu = 0,
  a_sig = 0.2, b_mu = 0, b_sig = 1, c_alpha = 5, c_beta = 46,
  report_sd = FALSE, debug = FALSE)

estimate_check_input(u, t, a, b, c)
}
\arguments{
\item{u}{a matrix of response data}

\item{t}{theta parameters}

\item{a}{a parameters}

\item{b}{b parameters}

\item{c}{c parameters}

\item{iter}{the number of maximum iterations}

\item{conv}{the convergence criterion}

\item{method}{the estimation method of item parameters}

\item{bound_t}{the bound of theta parameters}

\item{bound_a}{the bound of a parameters}

\item{bound_b}{the bound of b parameters}

\item{bound_c}{the bound of c parameters}

\item{mmle_mu}{the mean of the marginal distribution in MMLE}

\item{mmle_sig}{the SD of the marginal parameters in MMLE}

\item{scale}{the scaling parameter}

\item{scale_mean}{the mean of the scale}

\item{scale_sd}{the SD of the scale}

\item{debug}{\code{TRUE} to print and report debugging information}

\item{t_mu}{the mean of the prior distribution of theta parameters}

\item{t_sig}{the SD of the prior distribution of theta parameters}

\item{a_mu}{the mean of the prior distribution of a parameters}

\item{a_sig}{the SD of the prior distribution of a parameters}

\item{b_mu}{the mean of the prior distribution of b parameters}

\item{b_sig}{the SD of the prior distribution of b parameters}

\item{c_alpha}{the alpha of the prior distribution of c parameters}

\item{c_beta}{the beta of the prior distribution of c parameters}

\item{report_sd}{\code{TRUE} to report the posterior variance of thetas in EAP}
}
\value{
a list of \code{t, a, b, c} parameters
}
\description{
Estimation of 3PL Model

\code{estimate_mle} estimates parameters using joint or maximum likelihood estimation method

\code{estimate_bayesian} estimates parameters using Bayesian estimation method

a helper function to process input arguments
}
\details{
When the \code{t, a, b, c} parameters are \code{NULL}, they are free 
to be estimated; otherwise, they are fixed at the provided values. 
When setting values for a parameter, use numeric values to fix parameters
and \code{NA} to free parameters. For instance, an argument of \code{t=c(-1, NA, 1)}
means to fix the 1st and 3rd theta parameters to -1 and 1 and estimate the 2nd theta
parameters. The same is true for the a-, b-, and c-parameters. \cr
The \code{method} argument in \code{estimate_mle} controls whether to use joint (\code{jmle}) 
or maximum (\code{mmle}) likelihood method to estimate item parameters. The \code{scale} 
argument controls where to set the scale: \code{b} or \code{theta} parameters. \cr
When \code{debug} mode is on, print and report additional information regarding the convergence
over the iterations. \cr

The \code{method} argument in \code{estimate_bayesian} controls whether to use 
maximum (\code{map}) or expected (\code{eap}) a posteriori to estimate theta parameters. \cr
}
\examples{
\dontrun{
library(ggplot2)
library(dplyr)
set.seed(10001)
### generate data
data <- model_3pl()$gendata(1000, 40)
### MLE
x <- estimate_mle(data$responses, debug=TRUE)
y <- rbind(data.frame(param='t', true=data$people$theta, est=x$t),
     data.frame(param='a', true=data$items$a, est=x$a),
     data.frame(param='b', true=data$items$b, est=x$b),
     data.frame(param='c', true=data$items$c, est=x$c))
group_by(y, param) \%>\% 
summarise(corr=cor(true, est), rmse=rmse(true, est))
ggplot(y, aes(x=true, y=est, color=param)) + 
  geom_point(alpha=.5) + facet_wrap(~param, scales="free") + 
  xlab("True Parameters") + ylab("Estimated Parameters") +
  theme_bw()
group_by(y, param) \%>\% summarise(corr=cor(true, est), 
    rmse=rmse(true, est), mean=mean(est), sd=sd(est))
### Bayesian
x <- estimate_bayesian(data$responses, debug=TRUE)
y <- rbind(data.frame(param='t', true=data$people$theta, est=x$t),
     data.frame(param='a', true=data$items$a, est=x$a),
     data.frame(param='b', true=data$items$b, est=x$b),
     data.frame(param='c', true=data$items$c, est=x$c))
group_by(y, param) \%>\% summarise(corr=cor(true, est), rmse=rmse(true, est))
ggplot(y, aes(x=true, y=est, color=param)) + 
  geom_point(alpha=.5) + facet_wrap(~param, scales="free") + 
  xlab("True Parameters") + ylab("Estimated Parameters") +
  theme_bw()
group_by(y, param) \%>\% summarise(corr=cor(true, est), 
    rmse=rmse(true, est), mean=mean(est), sd=sd(est))
}
}

