% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module4_cat.R
\name{cat_sim}
\alias{cat_estimate_default}
\alias{cat_estimate_eap}
\alias{cat_estimate_hybrid}
\alias{cat_estimate_mle_step}
\alias{cat_select_ccat}
\alias{cat_select_default}
\alias{cat_select_shadow}
\alias{cat_sim}
\alias{cat_stop_default}
\alias{plot.cat}
\alias{print.cat}
\title{Computerized Adaptive Testing (CAT) Simulation}
\usage{
cat_sim(true, pool, ...)

cat_estimate_default(len, theta, stats, admin, pool, opts)

cat_estimate_mle_step(len, theta, stats, admin, pool, opts)

cat_estimate_eap(len, theta, stats, admin, pool, opts)

cat_estimate_hybrid(len, theta, stats, admin, pool, opts)

cat_stop_default(len, theta, stats, admin, pool, opts)

cat_select_default(len, theta, stats, admin, pool, opts)

cat_select_ccat(len, theta, stats, admin, pool, opts)

cat_select_shadow(len, theta, stats, admin, pool, opts)

\method{print}{cat}(x, ...)

\method{plot}{cat}(x, ...)
}
\arguments{
\item{true}{the true theta}

\item{pool}{the item pool (data.frame)}

\item{...}{additional option parameters. See details.}

\item{len}{the current test length}

\item{theta}{the current theta estimate}

\item{stats}{a matrix of responses and statistics}

\item{admin}{a data frame of administered item pool}

\item{opts}{a list of options passed in \code{cat_sim}}

\item{x}{a \code{cat} object}
}
\value{
\code{cat_sim} returns a \code{cat} object. See details.

the estimate rule should return a numeric value

the stopping rule should return a boolean with \code{TRUE} to stop the CAT

the selection rule should return a list of the selected item and the updated pool
}
\description{
\code{cat_sim} simulates CAT with user-defined algorithms

\code{cat_estimate_default} is a maximum likelihood estimator of
the theta parameter

\code{cat_estimate_mle_step} is a maximum likelihood estimator of
the theta parameter, with a fixed incremental/decremental change for all 1s or 
0s responses

\code{cat_estimate_eap} is an expected a posteriori estimator of
the theta parameter

\code{cat_estimate_hybrid} is a hybrid estimator of
the theta parameter: EAP for all 1s or 0s responses, and MLE otherwise

\code{cat_stop_default} is a trifold stopping rule: 
it is the minimum standard error rule when \code{stop_se} is set in options, 
the minimum information rule when \code{stop_mi} is set in options, and 
the 95% confidence interval rule when \code{stop_cut} is set in options

\code{cat_select_default} selects the item with maximum information or 
the item set with maximum averaged information for the current theta estimate.

\code{cat_select_ccat} implements the constrained CAT selection algorithm. 
The \code{'ccat_perc'} argument defines the percentage targets, and the \code{'ccat_var'}
argument defines the constrained variable.

\code{cat_select_shadow} implements the shadow-test CAT selection algorithm. 
The \code{'shadow_constraints'} argument defines the constraints.
}
\details{
\code{...} takes additional option/control parameters from users. \code{min} and {max} are
mandatory in order to control the minimum and maximum test length. \cr 
The selection, estimation, and stopping rules takes the same set of arguments: 
\code{fucntion(len, theta, stats, admin, pool, opts)}, which are the current test length, 
the current theta estimate, the matrix of statistics, the data.frame of administered items, 
the item pool, and the options. To override default rules, first write new rules using the 
same function signature and pass the new rule and its required parameters to \code{cat_sim()}
options. \cr
The returned \code{cat} object contains the remaining item pool, the administration history,
the true and estimated thetas. \cr
}
\examples{
## generate item pool
pool <- model_3pl()$gendata(1, 100)$items
pool$set_id <- sample(1:30, 100, replace=TRUE)
pool$content <- sample(1:3, 100, replace=TRUE)
pool$time <- round(rlnorm(100, mean=4.1, sd=.2))
## randomesque to control exposure in selection
cat_sim(1.0, pool, min=10, max=20, randomesque=5)
## use user-defined ID variable to select item sets
cat_sim(1.0, pool, min=10, max=20, selct_id="set")
## use the mle_step estimation rule
cat_sim(1.0, pool, min=10, max=20, mle_step=.5, 
    estimate_rule=cat_estimate_mle_step)
## use the hybrid estimation rule
cat_sim(1.0, pool, min=10, max=20, estimate_rule=cat_estimate_hybrid)
## use the standard error stopping rule
cat_sim(1.0, pool, min=10, max=20, stop_rule=cat_stop_default, stop_se=.25)
## use the 95\% confidence interval classification stopping rule
cat_sim(1.0, pool, min=10, max=20, stop_rule=cat_stop_default, stop_cut=0)
## use the constrained CAT item selection
cat_sim(1.0, pool, min=10, max=20, select_rule=cat_select_ccat, 
    ccat_var='content', ccat_perc=c('1'=.2, '2'=.3, '3'=.5))
## use the constrained CAT item selection with initial randomness
cat_sim(1.0, pool, min=10, max=20, select_rule=cat_select_ccat, 
    ccat_var='content', ccat_perc=c('1'=.2, '2'=.3, '3'=.5), ccat_init_rand=5)
## use the shadow-test CAT 
cons <- data.frame(var='content', level=1:3, min=3, max=5)
cons <- rbind(cons, data.frame(var='time', level=NA, min=55*10, max=65*10))
cat_sim(1.0, pool, min=10, max=10, shadow_constraints=cons, select_id="set_id")
}

