% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimation.R
\name{estimate.item.jmle}
\alias{estimate.item.bme}
\alias{estimate.item.jmle}
\alias{estimate.item.mmle}
\title{Item Calibration}
\usage{
estimate.item.jmle(u, theta, model = "3PL", iteration = 100, delta = 0.01,
  a.bound = 2, b.bound = 3.5, c.bound = 0.25, diagnose = FALSE)

estimate.item.mmle(u, model = "3PL", iteration = 100, delta = 0.01,
  a.bound = 2, b.bound = 3.5, c.bound = 0.25, diagnose = FALSE)

estimate.item.bme(u, model = "3PL", a.mu = 0, a.sig = 0.2, b.mu = 0,
  b.sig = 1, c.alpha = 5, c.beta = 23, iteration = 100, delta = 0.01,
  a.bound = 2, b.bound = 3.5, c.bound = 0.25, diagnose = FALSE)
}
\arguments{
\item{u}{a response matrix}

\item{theta}{a vector of theta parameters}

\item{model}{an IRT model used for calibration, taking values of "3PL", "2PL", "1PL", and "Rasch"}

\item{iteration}{the maximum iterations in Newton-Raphson procedure}

\item{delta}{the convergence criterion to terminate the Newton-Raphson procedure}

\item{a.bound}{the maximum value of estimated a parameters}

\item{b.bound}{the maximum absolute value of estimated b parameters}

\item{c.bound}{the maximum value of estimated c parameters}

\item{diagnose}{TRUE to return diangosis information}

\item{a.mu}{the log mean of the lognormal prior distribution for a pameters}

\item{a.sig}{the log sd of the lognormal prior distribution of a parmaeters}

\item{b.mu}{the mean of the normal prior distribution for b pameters}

\item{b.sig}{the sd of the normal prior distribution of b parmaeters}

\item{c.alpha}{alpah of the prior beta distribution for c pameters}

\item{c.beta}{beta of the prior beta distribution of c parmaeters}
}
\value{
estimated item parameters and diagnosis information if required
}
\description{
\code{estimate.item.jmle} calibrates item parameters with knwon thetas using joint maximum likelihood.

\code{estimate.item.mmle} calibrates item parameters using marginal maximum likelihood.

\code{estimate.item.bme} calibrates item parameters using bayesian maximum likelihood.
}
\details{
Diagnosis information contains the average changes and values of a-, b-, c-parameters over the Newton-Raphson procedure.\cr
For the joint maximum likelihood estimation, refer to Baker and Kim (2004), pp. 46-54.

For the marginal maximum likelihood estimation, refer to Baker and Kim (2004), pp.166-174.

For the Bayesian maximum likelihood estimation, refer to Baker and Kim (2004), pp.183-191.
}
\examples{
\dontrun{
# JMLE
x <- gen.rsp(gen.irt(3000, 30, a.sig=.4))
y <- estimate.item.jmle(x$rsp, x$thetas, model="3PL", diagnose=TRUE)
plot(x$items$a, y$parameters$a, xlim=c(0, 3), ylim=c(0, 3), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
plot(x$items$b, y$parameters$b, xlim=c(-3, 3), ylim=c(-3, 3), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
plot(x$items$c, y$parameters$c, xlim=c(0, .5), ylim=c(0, .5), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
}
\dontrun{
# MMLE
x <- gen.rsp(gen.irt(3000, 30, a.sig=.4))
y <- estimate.item.mmle(x$rsp, model="3PL", diagnose=TRUE)
plot(x$items$a, y$parameters$a, xlim=c(0, 3), ylim=c(0, 3), pch=16, col=rgb(.8,.2,.2,.5),)
abline(a=0, b=1, lty=2)
plot(x$items$b, y$parameters$b, xlim=c(-3, 3), ylim=c(-3, 3), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
plot(x$items$c, y$parameters$c, xlim=c(0, .5), ylim=c(0, .5), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
y$diagnosis$h
z <- estimate.theta.mle(x$rsp, y$parameters$a, y$parameters$b, y$parameters$c)
plot(x$thetas, z, xlim=c(-5, 5), ylim=c(-5, 5), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
}
\dontrun{
# BME
x <- gen.rsp(gen.irt(3000, 30, a.sig=.4))
y <- estimate.item.bme(x$rsp, model="3PL", diagnose=TRUE, a.mu=0, a.sig=.4, c.alpha=5, c.beta=30)
plot(x$items$a, y$parameters$a, xlim=c(0, 3), ylim=c(0, 3), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
plot(x$items$b, y$parameters$b, xlim=c(-3, 3), ylim=c(-3, 3), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
plot(x$items$c, y$parameters$c, xlim=c(0, .5), ylim=c(0, .5), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
y$diagnosis$h
z <- estimate.theta.mle(x$rsp, y$parameters$a, y$parameters$b, y$parameters$c)
plot(x$thetas, z, xlim=c(-5, 5), ylim=c(-5, 5), pch=16, col=rgb(.8,.2,.2,.5))
abline(a=0, b=1, lty=2)
}
}

