% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xspline.R
\name{xspline}
\alias{xspline}
\alias{model_surrogate_xspliner}
\alias{xspline.default}
\alias{xspline.formula}
\alias{xspline.explainer}
\title{Builds predictive model based GLM.}
\usage{
xspline(object, ...)

model_surrogate_xspliner(object, ...)

\method{xspline}{default}(object, lhs = NULL, response = NULL,
  predictors = NULL, data = NULL, form = "additive", bare = NULL,
  env = parent.frame(), ...)

\method{xspline}{formula}(object, model, data = NULL,
  consider = "specials", env = parent.frame(), ...)

\method{xspline}{explainer}(object, env = parent.frame(), ...)
}
\arguments{
\item{object}{Predictive model, formula or explainer (see DALEX) object.}

\item{...}{Other arguments passed to \code{xspline} methods or \link{build_xspliner}.}

\item{lhs}{Left-hand side of model formula. Can be transformed response.}

\item{response}{Name of response variable of \code{model}.}

\item{predictors}{Predictor values that should be used in final model.}

\item{data}{Training data of \code{model}.}

\item{form}{Can be 'additive' (default) or 'multiplicative'. Specifies formula form in final model.}

\item{bare}{Variable names that mustn't be transformed in final model.}

\item{env}{Environment in which optional variables passed into parameters are stored.
variables transformation. See vignette("xspliner") for details.}

\item{model}{When \code{object} is formula - predictive model. Basic model used for extracting predictors transformation.}

\item{consider}{One of \code{c("specials", "all")}. If "specials", only components with xs or xf
call are considered in transition.}
}
\value{
GLM object of class 'xspliner'.
}
\description{
The method provides main functionality on building GLM models with automatic variables transformation.
The transformations are based on specified single variable responses for selected black-box model.
See details in \code{vignette("xspliner")}.
}
\details{
model_surrogate_xspliner is a wrapper of xspline method to assure consistency with https://github.com/ModelOriented/DrWhy tools
}
\examples{
# preparing blackbox model
library(randomForest)
rf_iris <- randomForest(
  Petal.Width ~  Sepal.Length + Petal.Length + Species,
  data = iris)

# formula based xspliner
xs_iris <- xspline(
  Petal.Width ~ xs(Sepal.Length) + xs(Petal.Length) + xf(Species),
  model = rf_iris)
summary(xs_iris)
plot(xs_iris, "Sepal.Length")

# passing just the model
xs_iris <- xspline(rf_iris)
summary(xs_iris)
plot(xs_iris, "Sepal.Length")

# using DALEX
library(DALEX)
xs_iris_explainer <- explain(rf_iris)
xs_iris <- xspline(rf_iris)
summary(xs_iris)
plot(xs_iris, "Sepal.Length")

}
