% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootgam.R
\name{xpose.bootgam}
\alias{xpose.bootgam}
\title{Title}
\usage{
xpose.bootgam(object, n = n, id = object@Prefs@Xvardef$id, oid = "OID",
  seed = NULL, parnam = xvardef("parms", object)[1],
  covnams = xvardef("covariates", object),
  conv.value = object@Prefs@Bootgam.prefs$conv.value,
  check.interval = as.numeric(object@Prefs@Bootgam.prefs$check.interval),
  start.check = as.numeric(object@Prefs@Bootgam.prefs$start.check),
  algo = object@Prefs@Bootgam.prefs$algo,
  start.mod = object@Prefs@Bootgam.prefs$start.mod,
  liif = as.numeric(object@Prefs@Bootgam.prefs$liif),
  ljif.conv = as.numeric(object@Prefs@Bootgam.prefs$ljif.conv),
  excluded.ids = as.numeric(object@Prefs@Bootgam.prefs$excluded.ids), ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{n}{number of bootstrap iterations}

\item{id}{column name of id}

\item{oid}{create a new column with the original ID data}

\item{seed}{random seed}

\item{parnam}{ONE (and only one) model parameter name.}

\item{covnams}{Covariate names to test on parameter.}

\item{conv.value}{Convergence value}

\item{check.interval}{How often to check the convergence}

\item{start.check}{When to start checking}

\item{algo}{Which algorithm to use}

\item{start.mod}{which start model}

\item{liif}{The liif value}

\item{ljif.conv}{The convergence value for the liif}

\item{excluded.ids}{ID values to exclude.}

\item{...}{Used to pass arguments to more basic functions.}
}
\value{
a list of results from the bootstrap of the GAM.
}
\description{
Title
}
\examples{

## filter out occasion as a covariate as only one value
all_covs <- xvardef("covariates",simpraz.xpdb)
some_covs <- all_covs[!(all_covs \%in\% "OCC") ] 

## here only running n=5 replicates to see that things work
##   use something like n=100 for resonable results
boot_gam_obj <- xpose.bootgam(simpraz.xpdb,5,parnam="KA",covnams=some_covs,seed=1234)

}
\seealso{
Other GAM functions: \code{\link{GAM_summary_and_plot}},
  \code{\link{xp.get.disp}}, \code{\link{xp.scope3}},
  \code{\link{xpose.gam}}, \code{\link{xpose4-package}}
}
