% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenience.R
\name{auto_crosstab_to_wb}
\alias{auto_crosstab_to_wb}
\title{Take a cross tabulation produced by \code{reshape2::dcast} and output a formatted openxlsx wb object}
\usage{
auto_crosstab_to_wb(df, auto_number_format = TRUE, top_headers = NULL,
  titles = NULL, footers = NULL, auto_open = FALSE, indent = TRUE,
  left_header_colnames = NULL, vertical_border = TRUE, return_tab = FALSE,
  auto_merge = TRUE, insert_below_tab = NULL, total_text = NULL,
  include_header_rows = TRUE, wb = NULL, ws_name = NULL,
  number_format_overrides = list(), fill_non_values_with = list(na = NULL,
  nan = NULL, inf = NULL, neg_inf = NULL), allcount_to_level_translate = NULL,
  left_header_col_widths = NULL, body_header_col_widths = NULL)
}
\arguments{
\item{df}{A data.frame.  The cross tabulation to convert to Excel}

\item{auto_number_format}{Whether to automatically detect number format}

\item{top_headers}{A list.  Custom top headers. See \code{\link[=add_top_headers]{add_top_headers()}}}

\item{titles}{The title.  A character vector.  One element per row of title}

\item{footers}{Table footers.  A character vector.  One element per row of footer.}

\item{auto_open}{Boolean. Automatically open Excel output.}

\item{indent}{Automatically detect level of indentation of each row}

\item{left_header_colnames}{The names of the columns that you want to designate as left headers}

\item{vertical_border}{Boolean. Do you want a left border?}

\item{return_tab}{Boolean.  Return a tab object rather than a openxlsx workbook object}

\item{auto_merge}{Boolean.  Whether to merge cells in the title and footers to width of body}

\item{insert_below_tab}{A existing tab object.  If provided, this table will be written on the same sheet, below the provided tab.}

\item{total_text}{The text that is used for the 'grand total' of a cross tabulation}

\item{include_header_rows}{Boolean - whether to include or omit the header rows}

\item{wb}{A existing openxlsx workbook.  If not provided, a new one will be created}

\item{ws_name}{The name of the worksheet you want to write to}

\item{number_format_overrides}{e.g. list("colname1" = "currency1") see \link{auto_style_number_formatting}}

\item{fill_non_values_with}{Manually specify a list of strings that will replace non numbers types NA, NaN, Inf and -Inf. e.g. list(na = '*', nan = '', inf = '-', neg_inf = '--'). Note: NaNs are not treated as NAs.}

\item{allcount_to_level_translate}{Manually specify how to translate summary levels into header formatting}

\item{left_header_col_widths}{Width of row header columns you wish to set in Excel column width units. If singular, value is applied to all row header columns. If a vector, vector must have length equal to the number of row headers in workbook. Use special case "auto" for automatic sizing. Default (NULL) leaves column widths unchanged.}

\item{body_header_col_widths}{Width of body header columns you wish to set in Excel column width units. If singular, value is applied to all body columns. If a vector, vector must have length equal to the number of body headers in workbook. Use special case "auto" for automatic sizing. Default (NULL) leaves column widths unchanged.}
}
\description{
Take a cross tabulation produced by \code{reshape2::dcast} and output a formatted openxlsx wb object
}
\examples{
crosstab <- read.csv(system.file("extdata", "example_crosstab.csv", package="xltabr"))
wb <- auto_crosstab_to_wb(crosstab)
}
