% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.xhaz.bsplines.R
\name{predict.bsplines}
\alias{predict.bsplines}
\title{Predictions of excess hazard and net Survival from a \code{bsplines}
object}
\usage{
\method{predict}{bsplines}(object, new.data = NULL, times.pts = NULL, baseline = TRUE, ...)
}
\arguments{
\item{object}{an object of class \code{bsplines}}

\item{new.data}{new.data where is covariates}

\item{times.pts}{time in year scale to calculate the excess hazard. The
default value is NULL. In this case, time variable must be provided in the
new.data}

\item{baseline}{default is survival baseline; put \code{baseline = FALSE}
to estimate the net survival with covariates}

\item{...}{additional arguments affecting the predictions of excess hazard
and net survival}
}
\value{
An object of class predxhaz, which is a list of data.frame. Each
element of the list contains the estimates of hazard and survival at a fixed
time point. The return of this function can be used to produce graphics of
excess hazard or net survival, when times.pts argument is provided. This
object contains:

\item{times.pts}{the times value in year at which the excess hazard
and or the net survival have been estimated}

\item{hazard}{the excess hazard values based on the model of interest}

\item{survival}{the net survival values based on the model of interest}
}
\description{
Function to predict excess hazard and net survival based on
an object of class \code{bsplines}. The function allows the
predictions at several time points but not exceeding the maximum time of
follow-up from the baseline model.
}
\examples{

\donttest{
library("survival")
library("numDeriv")
library("survexp.fr")
library("splines")
data("dataCancer", package = "xhaz")   # load the data set in the package

fit.phBS <- xhaz(
        formula = Surv(obs_time_year, event) ~ ageCentre + immuno_trt,
        data = dataCancer, ratetable = survexp.fr,
        interval = c(0, NA, NA, max(dataCancer$obs_time_year)),
        rmap = list(age = 'age', sex = 'sexx', year = 'year_date'),
        baseline = "bsplines", pophaz = "classic")


print(fit.phBS)


predicted <- predict(object = fit.phBS,
                     new.data = dataCancer[1:10,],
                     times.pts = c(seq(0,10,1)),
                     baseline = TRUE)


#a list of predicted hazard and survival at different time points
print(predicted)


#predicted hazard and survival at time points 10 years
print(predicted[[10]])
}
}
\references{
Goungounga JA, Touraine C, Grafféo N, Giorgi R;
CENSUR working survival group. Correcting for misclassification
and selection effects in estimating net survival in clinical trials.
BMC Med Res Methodol. 2019 May 16;19(1):104.
doi: 10.1186/s12874-019-0747-3. PMID: 31096911; PMCID: PMC6524224.
(\href{https://pubmed.ncbi.nlm.nih.gov/31096911/}{PubMed})

Touraine C, Grafféo N, Giorgi R; CENSUR working survival group.
More accurate cancer-related excess mortality through correcting
background mortality for extra variables.
Stat Methods Med Res. 2020 Jan;29(1):122-136.
doi: 10.1177/0962280218823234. Epub 2019 Jan 23. PMID: 30674229.
(\href{https://pubmed.ncbi.nlm.nih.gov/30674229/}{PubMed})

Mba RD, Goungounga JA, Grafféo N, Giorgi R; CENSUR working survival group.
Correcting inaccurate background mortality in excess hazard models
through breakpoints. BMC Med Res Methodol. 2020 Oct 29;20(1):268.
doi: 10.1186/s12874-020-01139-z. PMID: 33121436; PMCID: PMC7596976.
(\href{https://pubmed.ncbi.nlm.nih.gov/33121436/}{PubMed})
}
\seealso{
\code{\link{xhaz}}, \code{\link{print.bsplines}}, \code{\link{print.constant}}
}
\author{
Juste Goungounga, Robert Darlin Mba, Nathalie Grafféo and Roch Giorgi
}
\keyword{predict.bsplines}
