% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/command.R
\name{upload_ftp}
\alias{upload_ftp}
\alias{upload_win_builder}
\title{Upload to an FTP server via \command{curl}}
\usage{
upload_ftp(file, server, dir = "")

upload_win_builder(file, version = c("R-devel", "R-release", "R-oldrelease"), 
    server = "ftp://win-builder.r-project.org/")
}
\arguments{
\item{file}{Path to a local file.}

\item{server}{The address of the FTP server.}

\item{dir}{The remote directory to which the file should be uploaded.}

\item{version}{The R version(s) on win-builder.}
}
\value{
Status code returned from \code{\link{system2}}.
}
\description{
Run the command \command{curl -T file server} to upload a file to an FTP
server. These functions require the system package (\emph{not the R package})
\command{curl} to be installed (which should be available on macOS by
default). The function \code{upload_win_builder()} uses \code{upload_ftp()}
to upload packages to the win-builder server.
}
\details{
These functions were written mainly to save package developers the trouble of
going to the win-builder web page and uploading packages there manually. You
may also consider using \code{devtools::check_win_*}, which currently only
allows you to upload a package to one folder on win-builder each time, and
\code{xfun::upload_win_builder()} uploads to all three folders, which is more
likely to be what you need.
}
