% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\docType{data}
\name{proj_root}
\alias{proj_root}
\alias{root_rules}
\title{Return the (possible) root directory of a project}
\format{
An object of class \code{matrix} (inherits from \code{array}) with 2 rows and 2 columns.
}
\usage{
proj_root(path = "./", rules = root_rules)

root_rules
}
\arguments{
\item{path}{The initial path to start the search. If it is a file path, its
parent directory will be used.}

\item{rules}{A matrix of character strings of two columns: the first column
contains regular expressions to look for filenames that match the patterns,
and the second column contains regular expressions to match the content of
the matched files. The regular expression can be an empty string, meaning
that it will match anything.}
}
\value{
Path to the root directory if found, otherwise \code{NULL}.
}
\description{
Given a path of a file (or dir) in a potential project (e.g., an R package or
an RStudio project), return the path to the project root directory.
}
\details{
The search for the root directory is performed by a series of tests,
currently including looking for a \file{DESCRIPTION} file that contains
\verb{Package: *} (which usually indicates an R package), and a
\file{*.Rproj} file that contains \verb{Version: *} (which usually indicates
an RStudio project). If files with the expected patterns are not found in the
initial directory, the search will be performed recursively in upper-level
directories.
}
\note{
This function was inspired by the \pkg{rprojroot} package, but is much
less sophisticated. It is a rather simple function designed to be used in
some of packages that I maintain, and may not meet the need of general
users until this note is removed in the future (which should be unlikely).
If you are sure that you are working on the types of projects mentioned in
the \sQuote{Details} section, this function may be helpful to you,
otherwise please consider using \pkg{rprojroot} instead.
}
\keyword{datasets}
