% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown.R
\name{fenced_block}
\alias{fenced_block}
\alias{make_fence}
\title{Create a fenced block in Markdown}
\usage{
fenced_block(x, attrs = NULL, fence = make_fence(x, char), char = "`")

make_fence(x, char = "`")
}
\arguments{
\item{x}{A character vector of the block content.}

\item{attrs}{A vector of block attributes.}

\item{fence}{The fence string, e.g., \code{:::} or \verb{```}. This will be
generated from the \code{char} argument by default.}

\item{char}{The fence character to be used to generate the fence string by
default.}
}
\value{
\code{fenced_block()} returns a character vector that contains both the
fences and content.

\code{make_fence()} returns a character string. If the block content
contains \code{N} fence characters (e.g., backticks), use \code{N + 1} characters as
the fence.
}
\description{
Wrap content with fence delimiters such as backticks (code blocks) or colons
(fenced Div). Optionally the fenced block can have attributes.
}
\examples{
# code block with class 'r' and ID 'foo'
xfun::fenced_block("1+1", c(".r", "#foo"))
# fenced Div
xfun::fenced_block("This is a **Div**.", char = ":")
# three backticks by default
xfun::make_fence("1+1")
# needs five backticks for the fences because content has four
xfun::make_fence(c("````r", "1+1", "````"))
}
