% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdown.R
\name{prose_index}
\alias{prose_index}
\title{Find the indices of lines in Markdown that are prose (not code blocks)}
\usage{
prose_index(x, warn = TRUE)
}
\arguments{
\item{x}{A character vector of text in Markdown.}

\item{warn}{Whether to emit a warning when code fences are not balanced.}
}
\value{
An integer vector of indices of lines that are prose in Markdown.
}
\description{
Filter out the indices of lines between code block fences such as \verb{```}
(could be three or four or more backticks).
}
\note{
If the code fences are not balanced (e.g., a starting fence without an
  ending fence), this function will treat all lines as prose.
}
\examples{
library(xfun)
prose_index(c("a", "```", "b", "```", "c"))
prose_index(c("a", "````", "```r", "1+1", "```", "````", "c"))
}
