% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{exit_call}
\alias{exit_call}
\title{Call \code{on.exit()} in a parent function}
\usage{
exit_call(fun, n = 2, ...)
}
\arguments{
\item{fun}{A function to be called when the parent function exits.}

\item{n}{The parent frame number. For \code{n = 1}, \code{exit_call(fun)} is
the same as \code{on.exit(fun())}; \code{n = 2} means adding
\code{on.exit(fun())} in the parent function; \code{n = 3} means the
grandparent, etc.}

\item{...}{Other arguments to be passed to \code{on.exit()}.}
}
\description{
The function \code{\link{on.exit}()} is often used to perform tasks when the
currennt function exits. This \code{exit_call()} function allows calling a
function when a parent function exits (thinking of it as inserting an
\code{on.exit()} call into the parent function).
}
\examples{
f = function(x) {
    print(x)
    xfun::exit_call(function() print("The parent function is exiting!"))
}
g = function(y) {
    f(y)
    print("f() has been called!")
}
g("An argument of g()!")
}
\references{
This function was inspired by Kevin Ushey:
  \url{https://yihui.org/en/2017/12/on-exit-parent/}
}
