% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGeneBenchmark.R
\name{testSelectGene}
\alias{testSelectGene}
\title{Test a gene selection function}
\usage{
testSelectGene(
  fit,
  method = "Uniform",
  howOften = 100,
  lF = NewlFselectGenes(),
  continuation = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{fit}{Fitness vector.}

\item{method}{String specifying the selection function. 
See \code{SelectGeneFactory()}.}

\item{howOften}{Integer.}

\item{lF}{Local configuration.}

\item{continuation}{Convert to index function?}

\item{verbose}{Boolean. Default: \code{FALSE}. 
If \code{TRUE}, the exection time of the transformation of the selection function
into a quasi-continuation function is printed on the console.}
}
\value{
\itemize{
        \item \code{$fit} fitness vector.
        \item \code{$newPop} indices of survivors in fitness vector.
        \item \code{$time} time in seconds. 
        \item \code{$size} population size.
        \item \code{$method} selection method used.
        }
}
\description{
\code{testSelectGene()} implements 
             testing a selection function.
             It collects the results of the repeated execution 
             of the selection function
             given a fitness function.
}
\examples{
fit1<-rep(10,10)
fit2<-fit1+runif(rep(10,1))
fit3<-sample(100, 10, replace=TRUE)
testSelectGene(fit2, method="Tournament", howOften=100) 
testSelectGene(fit3, method="Tournament", howOften=10) 
}
\seealso{
Other Benchmark Selection Functions: 
\code{\link{predictSelectTime}()},
\code{\link{runOneBenchmark}()},
\code{\link{runSelectBenchmarks}()},
\code{\link{selectBenchmark}()}
}
\concept{Benchmark Selection Functions}
