% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGene.R
\name{EvalGeneU}
\alias{EvalGeneU}
\title{Evaluates a gene in a problem environment}
\usage{
EvalGeneU(gene, lF)
}
\arguments{
\item{gene}{A gene.}

\item{lF}{The local configuration of the genetic algorithm.}
}
\value{
A gene (with \code{$evaluated==TRUE}).
}
\description{
\code{EvalGeneU} evaluates a gene in
             a problem environment.
}
\details{
If the evaluation of the fitness function of the 
         problem environment fails, the following 
         strategy is used: 
         We catch the error
         and print it, ignore it: 

         The error handler returns \code{NA}.
         
         We check for the error and update the gene:
         \itemize{
         \item \code{$evaluated}  TRUE.
         \item \code{$evalFail}   TRUE.
         \item \code{$fit} is set to the minimum fitness in the 
                population.
         }

         The boolean function \code{lF$ReportEvalErrors} controls
         the output of error messages for evaluation failures. 
         Rationale: In grammatical evolution, the standard approach 
         ignores attempts the evaluate incomplete programs.
}
\section{Future improvement}{

            Provide configurable error handlers.
            Rationale: Make debugging for new problem environments easier.
            Catch communication problems in distributed/parallel 
            environments.
}

\examples{
Parabola2D<-Parabola2DFactory()
lF<-NewlFevalGenes(Parabola2D)
g1<-list(evaluated=FALSE, fit=0, gene1=c(1.0, -1.5, 3.37))
g2<-list(evaluated=FALSE, fit=0, gene1=c(0.0, 0.0, 0.0))
EvalGeneU(g1, lF)
EvalGeneU(g2, lF)
}
\seealso{
Other Evaluation Functions: 
\code{\link{EvalGeneDet}()},
\code{\link{EvalGeneR}()},
\code{\link{EvalGeneStoch}()},
\code{\link{EvalGene}()}
}
\concept{Evaluation Functions}
