% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfMutate.R
\name{xegaDfMutateGeneDE}
\alias{xegaDfMutateGeneDE}
\title{Mutate a gene (differential mutation).}
\usage{
xegaDfMutateGeneDE(gene0, gene1, gene2, lF)
}
\arguments{
\item{gene0}{Real-coded gene (the base vector).}

\item{gene1}{Real-coded gene.}

\item{gene2}{Real-coded gene.}

\item{lF}{Local configuration.}
}
\value{
Real-coded gene.
}
\description{
\code{xegaDfMutateGeneDE} mutates a real-coded gene.
              The scale factor is given by Scalefactor().
}
\details{
The difference of gene1 and gene2 is scaled by 
          ScaleFactor() and added to gene0.
}
\examples{
gene0<-xegaDfInitGene(lFxegaDfGene)
gene1<-xegaDfInitGene(lFxegaDfGene)
gene2<-xegaDfInitGene(lFxegaDfGene)
gene<-xegaDfMutateGeneDE(gene0, gene1, gene2, lFxegaDfGene)
}
\references{
Price, Kenneth V., Storn, Rainer M. and Lampinen, Jouni A. (2005)
The Differential Evolution Algorithm (Chapter 2), pp. 37-134.
In: Differential Evolution. A Practical Approach to Global Optimization.
Springer, Berlin.
<doi:10.1007/3-540-31306-0>
}
\concept{Mutation}
