% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Calc_LD_v2_Commented.R
\name{calc_LD}
\alias{calc_LD}
\title{Calculate linkage disequilibrium}
\usage{
calc_LD(mat, MAF, method, LD_summary, saveAt, linkage_map, interval)
}
\arguments{
\item{mat}{(\code{matrix}) Matrix with phased genotypes of individuals coded as {11,12,21,22} for genotypes {AA, Aa, aA and AA} respectively. Dimension is \eqn{n*p} where n is number of individuals and p is twice the number of loci.}

\item{MAF}{\emph{Optional} Minor allele frequency threshold for LD calculation. Loci with minor allele frequency less than \code{MAF} will be excluded. Default: {0.05}.}

\item{method}{\emph{Optional} (\code{character}) Method to be used for calculation of LD. Possible options are:
\itemize{
\item{"adjacent"}  {LD will be calculated for adjacent loci only}.
\item{"pairwise"}  {LD will be calculated for all pairwise loci}.
}
Default: "adjacent"}

\item{LD_summary}{\emph{Optional} (\code{Logical}) Display LD calculation summary if is not \code{FALSE}. Default: \code{True}.}

\item{saveAt}{\emph{Optional} (\code{character}). Name to be used to save output files.}

\item{linkage_map}{\emph{Optional} (\code{data.frame}) or (\code{vector}) Linkage map of the loci for the measurement of LD decay. \bold{Note:} both argument \code{linkage_map} and \code{interval} should be present in the function and also argument \code{method} should be set to "pairwise" for the calculation of LD decay.}

\item{interval}{\emph{Optional} Interval to be used for grouping loci by their pairwise distance. See \code{details}.}
}
\value{
\code{list} with data of LD calculations.\cr
\describe{
\item{$Mean_r2}{Mean \eqn{r^2} for provided genotypes based on the method specified}. 
\item{$ld_data}{Data frame with 12 columns including pair id, frequencies of alleles and haplotypes for each pair as well as measurements of LD}.  
\item{$ld_decay}{Data for LD decay including the average \eqn{r^2} for loci pairs in each interval}.  
}
}
\description{
Different measures of linkage disequilibrium (LD) such as \eqn{D},\eqn{r} and \eqn{r^2} are calculated for phased genotypes. LD measurements can be calculated both for adjacent and pairwise loci. Decay of LD between marker pairs can be assessed as well.
}
\details{
The extent of LD is an important factor both in association studies and genomic selection. Commonly used measure to calculate LD between loci A and B is Pearson coefficient (\eqn{r}) of correlation as: \cr 
\deqn{r = D/ \sqrt{(p_1p_2q_1q_2)}}  \cr 
where \eqn{D} is \cr 
\deqn{D_{ij}=p(A_iB_j)-p(A_i)p(B_j)} \cr 
However, squared coefficient of correlation \eqn{r^2} is often used to remove the arbitrary sign introduced: \cr 
\deqn{r^2_{ij} = D^2_{ij}/ (p(A_i)(1-p(A_i))p(B_j)(1-p(B_j)))}
\cr
To determine the decay of LD with increasing distance between loci (SNPs), the average \eqn{r^2} can be expressed as a function of distance between SNPs. SNP pairs are grouped by their pairwise distance into intervals defined by the user in argument \code{interval}. The average \eqn{r^2} for SNP pairs in each interval are estimated as the mean of all \eqn{r^2} within that interval.
}
\examples{
# Calculate mean r2 and LD decay.

genome<-data.frame(matrix(NA, nrow=1, ncol=6))
names(genome)<-c("chr","len","nmrk","mpos","nqtl","qpos")
genome$chr<-c(1)
genome$len<-c(100)	
genome$nmrk<-c(100)
genome$mpos<-c("rnd")	
genome$nqtl<-c(50)
genome$qpos<-c("even")	
genome

hp<-make_hp(hpsize=100,
ng=10,h2=0.3,phen_var=1 ,genome=genome,
mutr=2.5e-4)

# Mean r2

mat<-hp$hp_mrk[,-1]
rLD<-calc_LD(mat=mat,MAF=0.1,method='adjacent',LD_summary=TRUE)

# LD decay

 linkage_map<-hp$linkage_map_mrk[,3]
 rLD<-calc_LD(mat=mat,MAF=0.1,method='pairwise'
,LD_summary=TRUE,linkage_map=linkage_map,interval=5)

rLD$ld_decay
}
