% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/banner.R
\name{use_banner}
\alias{use_banner}
\title{Add a banner to the top or bottom of your slides.}
\usage{
use_banner(
  ...,
  bottom_left = NULL,
  bottom_center = NULL,
  bottom_right = NULL,
  top_left = NULL,
  top_center = NULL,
  top_right = NULL,
  exclude = NULL
)
}
\arguments{
\item{...}{Banner styles created with \code{\link[=style_banner]{style_banner()}}. Technically,
additional arguments are added into the \code{\link[htmltools:tagList]{htmltools::tagList()}} with the
banner dependencies, but you'll only want to use \code{\link[=style_banner]{style_banner()}} calls
here.}

\item{bottom_left, top_left}{Text or HTML to place in the left column of the
top or bottom of the slide.}

\item{bottom_center, top_center}{Text or HTML to place in the center column
at the top or the bottom of the slide.}

\item{bottom_right, top_right}{Text or HTML to place in the right column of
the top or bottom of the slide.}

\item{exclude}{A vector of slide classes where the banner should not be
applied. By default all slides are included, but you might want to exclude
the title and inverse slides with \code{exclude = c("title-slide", "inverse")}.}
}
\value{
An \code{\link[htmltools:tagList]{htmltools::tagList()}} with the banner dependencies, or an
\link[htmltools:htmlDependency]{htmltools::htmlDependency}.
}
\description{
Adds a banner to all the slides in your deck at the top or the bottom of the
slide. You can place content in the left, center, or right portion of the
banner.
}
\examples{
use_banner(bottom_left = "bit.ly/my-awesome-slides")

use_banner(
  bottom_left = "bit.ly/my-awesome-slides",
  top_center = "My Presentation",
  exclude = c("title-slide", "inverse"),
  style_banner(text_color = "grey")
)

}
\seealso{
\code{\link[=style_banner]{style_banner()}}
}
