% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CSAb.R
\docType{class}
\name{CSAb-class}
\alias{CSAb}
\title{CSAb Class}
\arguments{
\item{thres_cpty}{The maximum exposure that the counterparty can generate before collateral will need to be posted}

\item{thres_PO}{The maximum exposure that the processing organization can generate before collateral will need to be posted}

\item{MTA_cpty}{The minimum transfer amount for the counterparty}

\item{MTA_PO}{The minimum transfer amount for the processing organization}

\item{IM_cpty}{The initial margin that is posted by the counterparty}

\item{IM_PO}{The initial margin that is posted by the processing organization}

\item{mpor_days}{The margin period of risk in days}

\item{remargin_freq}{The frequency of re-margining the exposure in days}

\item{rounding}{The rounding amount of the transfers}
}
\value{
An object of type CSAb
}
\description{
Creates a collateral agreement Object containing all the relevant data and methods regarding the maturity factor
 and the calculation of the exposures after applying the relevant threshold
}
\examples{
## the margin agreement given in the Basel regulation example
coll = CSAb(thres_cpty = 0, MTA_cpty = 5, IM_cpty = 150, remargin_freq = 5)
}
\author{
Tasos Grivas <tasos@openriskcalculator.com>
}
\references{
Basel Committee: The standardised approach for measuring counterparty credit risk exposures
http://www.bis.org/publ/bcbs279.htm
}

