% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_coloc}
\alias{xQTLvisual_coloc}
\title{Heatmap plot of the LD-p-value relationship of the eQTL}
\usage{
xQTLvisual_coloc(
  gene = "",
  geneType = "auto",
  variantName = "",
  variantType = "auto",
  tissueLabels = "",
  study = "",
  population = "EUR"
)
}
\arguments{
\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{tissueLabels}{(a character vector) can be listed with \code{ebi_study_tissues}. If is null, use all tissue / cell-types. (Default)}

\item{study}{(character) Studies can be listed using \code{ebi_study_tissues}. If is null, use all studies (Default).}

\item{population}{(string) One of the 5 popuations from 1000 Genomes: 'AFR', 'AMR', 'EAS', 'EUR', and 'SAS'.}
}
\value{
A list containing a data.table object and a ggplot object
}
\description{
Heatmap plot of the LD-p-value relationship of the eQTL
}
\examples{
\donttest{
heatmapQTL <- xQTLvisual_coloc( gene="MMP7", variantName="rs11568818", study="TwinsUK")
}
}
