% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{retrieveLD_LDproxy}
\alias{retrieveLD_LDproxy}
\title{Retrieve SNP pairwise LD from LDlink database}
\usage{
retrieveLD_LDproxy(
  targetSnp = "",
  population = "EUR",
  windowSize = 50000,
  method = "download",
  genomeVersion = "grch38",
  max_count = 3,
  token = "9246d2db7917"
)
}
\arguments{
\item{targetSnp}{target SNP, support dbSNP IP.}

\item{population}{Supported population is consistent with the LDlink, which can be listed using function LDlinkR::list_pop()}

\item{windowSize}{Window around the highlighted snp for querying linkage disequilibrium information. Default:500000}

\item{method}{The same as fetchContent function, can be chosen from "download", "curl", "GetWithHeader".}

\item{genomeVersion}{"grch38"(default) or "grch37".}

\item{max_count}{To prevent download failure due to network fluctuations, max number of connection attempts.}

\item{token}{Ldlink token, default: "9246d2db7917"}
}
\value{
A data.table object.
}
\description{
Retrieve SNP pairwise LD from LDlink database
}
