% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_eqtlExp}
\alias{xQTLvisual_eqtlExp}
\title{Boxplot of normalized expression among genotypes for eQTL.}
\usage{
xQTLvisual_eqtlExp(
  variantName = "",
  gene = "",
  variantType = "auto",
  geneType = "auto",
  tissueSiteDetail = ""
)
}
\arguments{
\item{variantName}{(character) name of variant, dbsnp ID and variant id is supported, eg. "rs138420351" and "chr17_7796745_C_T_b38".}

\item{gene}{(character) gene symbol or gencode id (versioned or unversioned are both supported).}

\item{variantType}{(character) options: "auto", "snpId" or "variantId". Default: "auto".}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}
}
\value{
A list containing eQTL detail, expression profile and a ggplot object.
}
\description{
Boxplot of normalized expression among genotypes for eQTL.
}
\examples{
\donttest{
expEqtl<-xQTLvisual_eqtlExp(variantName="rs3778754",gene ="IRF5",tissueSiteDetail="Whole Blood")
}
}
