% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{xQTLanalyze_coloc_diy}
\alias{xQTLanalyze_coloc_diy}
\title{conduct colocalization analysis with customized xQTL data}
\usage{
xQTLanalyze_coloc_diy(
  gwasDF,
  qtlDF,
  mafThreshold = 0.01,
  gwasSampleNum = 50000,
  qtlSampleNum = 10000,
  method = "coloc",
  bb.alg = FALSE
)
}
\arguments{
\item{gwasDF}{data.frame or data.table, required cols: rsid, chrom, position, pValue, maf, beta, se}

\item{qtlDF}{data.frame or data.table, required cols:  rsid, chrom, position, pValue, maf, beta, se}

\item{mafThreshold}{Cutoff of maf to remove rare variants.}

\item{gwasSampleNum}{Sample number of GWAS dataset. Default:50000.}

\item{qtlSampleNum}{Sample number of QTL dataset. Default:10000.}

\item{method}{(character) options: "coloc"(default) or "hyprcoloc" (need a highe version).}

\item{bb.alg}{For \code{hyprcoloc}, branch and bound algorithm: TRUE, employ BB algorithm; FALSE, do not. Default: FALSE.}
}
\value{
A list
}
\description{
conduct colocalization analysis with customized xQTL data
}
\examples{
\donttest{
url1 <- "https://raw.githubusercontent.com/dingruofan/exampleData/master/gwasDFsub_MMP7.txt"
url2 <- "https://raw.githubusercontent.com/dingruofan/exampleData/master/eqtl/MMP7_qtlDF.txt"
gwasDF <- data.table::fread(url1)
qtlDF <- data.table::fread(url2)
output <- xQTLanalyze_coloc_diy(gwasDF = gwasDF, qtlDF=qtlDF, method="coloc")
}
}
