% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize.R
\name{xQTLvisual_qtlPropensity}
\alias{xQTLvisual_qtlPropensity}
\title{Visualization of QTL specificity among multiple cells/tissues.}
\usage{
xQTLvisual_qtlPropensity(propensityRes, P_cutoff = 1)
}
\arguments{
\item{propensityRes}{A data.table object from the function \code{xQTLanalyze_propensity}}

\item{P_cutoff}{(numeric) cutoff of the p-value of tissue propensity. Default: 1}
}
\value{
A ggplot object
}
\description{
Visualization of QTL specificity among multiple cells/tissues.
}
\examples{
\donttest{
propensityRes <- xQTLanalyze_propensity( gene="MMP7", variantName="rs11568818", study="TwinsUK")
xQTLvisual_qtlPropensity(propensityRes)
}
}
