% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze.R
\name{xQTLanalyze_TSExp}
\alias{xQTLanalyze_TSExp}
\title{Perform tissue-specific expression analysis for genes.}
\usage{
xQTLanalyze_TSExp(
  genes,
  geneType = "auto",
  method = "SPM",
  datasetId = "gtex_v8"
)
}
\arguments{
\item{genes}{A charater vector or a string of gene symbol, gencode id (versioned), or a charater string of gene type.}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{method}{"SPM" or "entropy"}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}
}
\value{
A data.table object.
}
\description{
Perform tissue-specific expression analysis for genes.
}
\examples{
TSgene <- xQTLanalyze_TSExp(extractGeneInfo(gencodeGeneInfoAllGranges)$gencodeId[1:5])
}
