% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x3p_flip_x.R
\name{x3p_flip_x}
\alias{x3p_flip_x}
\alias{x_flip_x3p}
\title{Flip the x coordinate of an x3p file}
\usage{
x3p_flip_x(x3p)

x_flip_x3p(x3p)
}
\arguments{
\item{x3p}{x3p object}
}
\value{
x3p object in which the x coordinate is reversed.
}
\description{
Flip the surface matrix of an x3p file along the x axis.
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
dim(logo$surface.matrix)
\dontrun{
x3p_image(logo)
}
# flip the y-axis for the old ISO standard:
logoflip <- x3p_flip_x(logo)
dim(logoflip$surface.matrix)
\dontrun{
x3p_image(logoflip)
}
}
