% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmf.R
\name{wmf}
\alias{wmf}
\title{Computes the wavelet mean field from a matrix of spatiotemporal data. Also the
creator function for the \code{wmf} class.}
\usage{
wmf(dat, times, scale.min = 2, scale.max.input = NULL, sigma = 1.05, f0 = 1)
}
\arguments{
\item{dat}{A locations (rows) x time (columns) matrix}

\item{times}{A vector of time step values (e.g., years), spacing 1}

\item{scale.min}{The smallest scale of fluctuation that will be examined. At least 2.}

\item{scale.max.input}{The largest scale of fluctuation that will be examined. Note that if this is set too high relative to the length of the timeseries it will be truncated.}

\item{sigma}{The ratio of each time scale examined relative to the next timescale. Greater than 1.}

\item{f0}{The ratio of the period of fluctuation to the width of the envelope}
}
\value{
\code{wmf} returns an object of class \code{wmf}. Slots are:
\item{values}{A matrix of complex numbers containing the wavelet mean field, of dimensions \code{length(times)} 
by the number of timescales. Entries not considered reliable (longer timescales, near the edges of the time span) 
are set to NA.}
\item{times}{The time steps specified (e.g., years)}
\item{timescales}{The timescales (1/frequency) computed for the wavelet transforms}
\item{dat}{The data matrix (locations by time) from which the wmf was computed}
\item{wtopt}{The inputted wavelet transform options scale.min, scale.max.input, sigma, f0 in a list}
}
\description{
Computes the wavelet mean field from a matrix of spatiotemporal data. Also the
creator function for the \code{wmf} class. The \code{wmf} class inherits from the 
\code{tts} class, which inherits from the \code{list} class.
}
\examples{
times<-1:30 #generate time steps
#generate fake count data for 20 locations
dat<-matrix(rpois(20*length(times),20),nrow=20,ncol=length(times)) 
dat<-cleandat(dat=dat,times=times,clev=2)$cdat #detrend and demean
wmf<-wmf(dat,times)

}
\references{
Sheppard, L.W., et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid pests. 
Nature Climate Change. DOI: 10.1038/nclimate2881
}
\seealso{
\code{\link{wmf_methods}}, \code{\link{tts}}, \code{\link{wpmf}}, \code{\link{plotmag}},
\code{browseVignettes("wsyn")}
}
\author{
Jonathan Walter, \email{jaw3es@virginia.edu}; Lawrence Sheppard, \email{lwsheppard@ku.edu}; 
Daniel Reuman, \email{reuman@ku.edu}
}
