% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surrog.R
\name{surrog}
\alias{surrog}
\title{Creates surrogate time series, either Fourier surrogates or amplitude adjusted 
Fourier surrogates}
\usage{
surrog(dat, nsurrogs, surrtype, syncpres)
}
\arguments{
\item{dat}{A locations x time matrix of observations (for multiple-time series input), or a single vector}

\item{nsurrogs}{The number of surrogates to produce}

\item{surrtype}{Either "fft" (for Fourier surrogates) or "aaft" (for amplitude adjusted Fourier surrogates). 
Fourier surrogates are appropriate for time series with normal marginals; otherwise consider aaft surrogates.}

\item{syncpres}{Logical. TRUE for "synchrony preserving" surrogates (same phase randomizations used for all time 
series). FALSE leads to independent phase randomizations for all time series.}
}
\value{
\code{surrog} returns a list of nsurrogs surrogate datasets
}
\description{
For significance testing wavelet coherence and other purposes
}
\details{
Fourier surrogates are somewhat faster than \code{aaft} surrogates, and may be much faster when 
some of the time series in the data have ties. Prenormalization (e.g., using \code{cleandat}) can 
make it possible to use \code{fft} surrogates.
}
\examples{
times<-1:100
dat<-sin(2*pi*times/10)
nsurrogs<-10
surrtype<-"fft"
syncpres<-TRUE
res<-surrog(dat,nsurrogs,surrtype,syncpres)

}
\references{
Sheppard, LW, et al. (2016) Changes in large-scale climate alter spatial synchrony of aphid pests. Nature Climate 
Change. DOI: 10.1038/nclimate2881

Schreiber, T and Schmitz, A (2000) Surrogate time series. Physica D 142, 346-382.

Prichard, D and Theiler, J (1994) Generating surrogate data for time series with several simultaneously measured 
variables. Physical Review Letters 73, 951-954.
}
\seealso{
\code{\link{wpmf}}, \code{\link{coh}}, \code{\link{wlmtest}}, \code{\link{synmat}},
\code{browseVignettes("wsyn")}
}
\author{
Jonathan Walter, \email{jaw3es@virginia.edu}; Lawrence Sheppard, \email{lwsheppard@ku.edu}; 
Daniel Reuman, \email{reuman@ku.edu}
}
