% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeFasta2.R
\name{writeFasta2}
\alias{writeFasta2}
\title{Write sequences in fasta format to file
  
This function writes sequences from character vector as fasta formatted file (from \href{https://www.uniprot.org}{UniProt}) 
Line-headers are based on names of elements of input vector \code{prot}.
This function also allows comparing the main vector of sequences with a reference vector \code{ref} to check if any of the sequences therein are truncated.}
\usage{
writeFasta2(
  prot,
  fileNa = NULL,
  ref = NULL,
  lineLength = 60,
  eol = "\\n",
  truSuf = "_tru",
  silent = FALSE,
  debug = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{prot}{(character) vector of sequenes, names will be used for fasta-header}

\item{fileNa}{(character) name (and path) for file to be written}

\item{ref}{(character) optional/additional set of (reference-) sequences (only for comparison to \code{prot}), length of proteins from \code{prot} will be checked to mark truncated proteins by '_tru'}

\item{lineLength}{(integer, length=1) number of sequence characters per line (default 60, should be >1 and <10000)}

\item{eol}{(character) the character(s) to print at the end of each line (row); for example, eol = "\\r\\n" will produce Windows' line endings on a Unix-alike OS}

\item{truSuf}{(character) suffix to be added for sequences found truncated when comparing with \code{ref}}

\item{silent}{(logical) suppress messages}

\item{debug}{(logical) supplemental messages for debugging}

\item{callFrom}{(character) allows easier tracking of messages produced}
}
\value{
This function writes the sequences from \code{prot} as fasta formatted-file
}
\description{
Write sequences in fasta format to file
  
This function writes sequences from character vector as fasta formatted file (from \href{https://www.uniprot.org}{UniProt}) 
Line-headers are based on names of elements of input vector \code{prot}.
This function also allows comparing the main vector of sequences with a reference vector \code{ref} to check if any of the sequences therein are truncated.
}
\details{
Sequences without any names will be given generic headers like protein01 ... etc.
}
\examples{
#  
prots <- c(SEQU1="ABCDEFGHIJKL", SEQU2="CDEFGHIJKLMNOP")
writeFasta2(prots, fileNa=file.path(tempdir(),"testWrite.fasta"), lineLength=6)
}
\seealso{
\code{\link{readFasta2}} for reading fasta, \code{write.fasta} from the package \href{https://CRAN.R-project.org/package=seqinr}{seqinr}
}
