% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readProlineFile.R
\name{readProlineFile}
\alias{readProlineFile}
\title{Read xlsx, csv or tsv files exported from Proline and MS-Angel}
\usage{
readProlineFile(
  fileName,
  path = NULL,
  normalizeMeth = "median",
  logConvert = TRUE,
  sampleNames = NULL,
  quantCol = "^abundance_",
  annotCol = c("accession", "description", "is_validated", "protein_set_score",
    "X.peptides", "X.specific_peptides"),
  remStrainNo = TRUE,
  pepCountCol = c("^psm_count_", "^peptides_count_"),
  trimColnames = FALSE,
  refLi = NULL,
  separateAnnot = TRUE,
  plotGraph = TRUE,
  titGraph = NULL,
  wex = 2,
  specPref = c(conta = "_conta\\\\|", mainSpecies = "OS=Homo sapiens"),
  gr = NULL,
  sdrf = NULL,
  suplAnnotFile = TRUE,
  groupPref = list(lowNumberOfGroups = TRUE),
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{fileName}{(character) name of file to read; .xlsx-, .csv-, .txt- and .tsv can be read (csv, txt and tsv may be gz-compressed). Reading xlsx requires package 'readxl'.}

\item{path}{(character) optional path (note: Windows backslash sould be protected or written as '/')}

\item{normalizeMeth}{(character) normalization method (for details and options see \code{\link[wrMisc]{normalizeThis}})}

\item{logConvert}{(logical) convert numeric data as log2, will be placed in $quant}

\item{sampleNames}{(character) custom column-names for quantification data; this argument has priority over \code{suplAnnotFile}}

\item{quantCol}{(character or integer) colums with main quantitation-data : precise colnames to extract, or if length=1 content of \code{quantCol} will be used as pattern to search among column-names for $quant using \code{grep}}

\item{annotCol}{(character) precise colnames or if length=1 pattern to search among column-names for $annot}

\item{remStrainNo}{(logical) if \code{TRUE}, the organism annotation will be trimmed to uppercaseWord+space+lowercaseWord (eg Homo sapiens)}

\item{pepCountCol}{(character) pattern to search among column-names for count data of PSM and NoOfPeptides}

\item{trimColnames}{(logical) optional trimming of column-names of any redundant characters from beginning and end}

\item{refLi}{(integer) custom decide which line of data is main species, if single character entry it will be used to choose a group of species (eg 'mainSpe')}

\item{separateAnnot}{(logical) separate annotation form numeric data (quantCol and annotCol must be defined)}

\item{plotGraph}{(logical or matrix of integer) optional plot vioplot of initial data; if integer, it will be passed to \code{layout} when plotting}

\item{titGraph}{(character) custom title to plot of distribution of quantitation values}

\item{wex}{(integer) relative expansion factor of the violin-plot (will be passed to \code{\link[wrGraph]{vioplotW}})}

\item{specPref}{(character or list) define characteristic text for recognizing (main) groups of species (1st for comtaminants - will be marked as 'conta', 2nd for main species- marked as 'mainSpe',
and optional following ones for supplemental tags/species - maked as 'species2','species3',...);
if list and list-element has multiple values they will be used for exact matching of accessions (ie 2nd of argument \code{annotCol})}

\item{gr}{(character or factor) custom defined pattern of replicate association, will override final grouping of replicates from \code{sdrf} and/or \code{suplAnnotFile} (if provided)   \code{}}

\item{sdrf}{(character, list or data.frame) optional extraction and adding of experimenal meta-data: if character, this may be the ID at ProteomeExchange,
the second & third elements may give futher indicatations for automatic organization of groups of replicates.
Besides, the output from \code{readSdrf} or a list from \code{defineSamples} may be provided;
if \code{gr} is provided, \code{gr} gets priority for grouping of replicates;
if \code{sdrfOrder=TRUE} the output will be put in order of sdrf}

\item{suplAnnotFile}{(logical or character) optional reading of supplemental files produced by quantification software; however, if \code{gr} is provided, \code{gr} gets priority for grouping of replicates;
if \code{TRUE} defaults to file '*InputFiles.txt' (needed to match information of \code{sdrf}) which can be exported next to main quantitation results;
if \code{character} the respective file-name (relative or absolute path)}

\item{groupPref}{(list) additional parameters for interpreting meta-data to identify structure of groups (replicates), will be passed to \code{readSampleMetaData}.
May contain \code{lowNumberOfGroups=FALSE} for automatically choosing a rather elevated number of groups if possible (defaults to low number of groups, ie higher number of samples per group)}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns a list with \code{$raw} (initial/raw abundance values), \code{$quant} with final normalized quantitations, \code{$annot} (columns ), \code{$counts} an array with 'PSM' and 'NoOfPeptides', \code{$quantNotes} and \code{$notes}; or a data.frame with quantitation and annotation if \code{separateAnnot=FALSE}
}
\description{
Quantification results from Proline \href{http://www.profiproteomics.fr/proline/}{Proline} and MS-Angel exported as xlsx format can be read directly using this function.
Besides, files in tsv, csv (European and US format) or tabulated txt can be read, too.
Then relevant information gets extracted, the data can optionally normalized and displayed as boxplot or vioplot.
The final output is a list containing 6 elements: \code{$raw}, \code{$quant},  \code{$annot}, \code{$counts}, \code{$quantNotes} and \code{$notes}.
Alternatively, a data.frame with annotation and quantitation data may be returned if \code{separateAnnot=FALSE}.
Note: There is no normalization by default since quite frequently data produced by Proline are already sufficiently normalized.
The figure produced using the argument \code{plotGraph=TRUE} may help judging if the data appear sufficiently normalized (distribtions should align).
}
\details{
This function has been developed using Proline version 1.6.1 coupled with MS-Angel 1.6.1.
The classical way of using ths function consists in exporting results produced by Proline and MS-Angel as xlsx file.
Besides, other formats may be read, too. This includes csv (eg the main sheet/table of ths xlsx exported file saved as csv).
\href{https://github.com/wombat-p}{WOMBAT} represents an effort to automatize quantitative proteomics experiments, using this route
data get exported as txt files which can be read, too.
}
\examples{
path1 <- system.file("extdata", package="wrProteo")
fiNa <- "exampleProlineABC.csv.gz"
dataABC <- readProlineFile(path=path1, file=fiNa)
summary(dataABC$quant)
}
\seealso{
\code{\link[utils]{read.table}}
}
