% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalizeThis.R
\name{normalizeThis}
\alias{normalizeThis}
\title{Normalize data in various modes}
\usage{
normalizeThis(
  dat,
  method = "mean",
  refLines = NULL,
  refGrp = NULL,
  trimFa = NULL,
  quantFa = NULL,
  expFa = NULL,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{matrix or data.frame}

\item{method}{(character) may be "mean","median","NULL","none", "trimMean", "slope", "exponent", "slope2Sections", "vsn"; When NULL or 'none' is chosen the input will be returned}

\item{refLines}{(NULL or numeric) allows to consider only specific lines of 'dat' when determining normalization factors (all data will be normalized)}

\item{refGrp}{Only the columns indicated will be used as reference, default all columns (integer or colnames)}

\item{trimFa}{(numeric, length=1) additional parameters for trimmed mean}

\item{quantFa}{(numeric, length=2) additional parameters for quantiles to use with method='slope'}

\item{expFa}{(numeric, length=1) additional parameters for method='exponent'}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a matrix of normalized data
}
\description{
Generic normalization of 'dat' (by columns), multiple methods may be applied.
The choice of normalization procedures must be done with care, plotting the data before and after normalization 
may be critical to understandig the initial data structure and the effect of the procedure applied. 
Inappropriate methods chosen may render interpretation of (further) results incorrect.
Normalization using the method \code{vsn} runs \code{\link[vsn]{justvsn}} from \href{https://bioconductor.org/packages/release/bioc/html/vsn.html}{vsn} 
(this requires a minimum of 42 rows of input-data).
Note : Depending on the procedure chosen, the normalized data may appear on a different scale.
}
\examples{
set.seed(2015); rand1 <- round(runif(300)+rnorm(300,0,2),3)
dat1 <- cbind(ser1=round(100:1+rand1[1:100]), ser2=round(1.2*(100:1+rand1[101:200])-2),
  ser3=round((100:1 +rand1[201:300])^1.2-3))
dat1 <- cbind(dat1, ser4=round(dat1[,1]^seq(2,5,length.out=100)+rand1[11:110],1))
dat1[dat1 <1] <- NA
  summary(dat1)
  head( .normalize(dat1,"mean",list()))
  dat1[c(1:5,50:54,95:100),]
no1 <- normalizeThis(dat1, refGrp=1:3, meth="mean")
no2 <- normalizeThis(dat1, refGrp=1:3, meth="trimMean", trim=0.4)
no3 <- normalizeThis(dat1, refGrp=1:3, meth="median")
no4 <- normalizeThis(dat1, refGrp=1:3, meth="slope", quantFa=c(0.2,0.8))
dat1[c(1:10,91:100),]
cor(dat1[,3],rowMeans(dat1[,1:2],na.rm=TRUE),use="complete.obs")             # high
cor(dat1[,4],rowMeans(dat1[,1:2],na.rm=TRUE),use="complete.obs")             # bad
cor(dat1[c(1:10,91:100),4],rowMeans(dat1[c(1:10,91:100),1:2],na.rm=TRUE),use="complete.obs")
cor(dat1[,3],rowMeans(dat1[,1:2],na.rm=TRUE)^ (1/seq(2,5,length.out=100)),use="complete.obs")
}
\seealso{
\code{\link{exponNormalize}}, \code{\link{adjBy2ptReg}}, \code{\link[vsn]{justvsn}}
}
