% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randIndFx.R
\name{randIndFx}
\alias{randIndFx}
\title{Distance of categorical data (Jaccard,Rand and adjusted Rand index)}
\usage{
randIndFx(ma, method = "ARI", adjSense = TRUE, silent = FALSE, callFrom = NULL)
}
\arguments{
\item{ma}{(matrix) main input for distance calulation}

\item{method}{(character) name of distance method (eg "ARI","RI","J","FM")}

\item{adjSense}{(logical) allows introducing correlation/anticorrelation (interprete neg distance results as anti)}

\item{silent}{(logical) suppres messages}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function returns a distance matrix
}
\description{
\code{randIndFx} calculates distance of categorical data (as Rand Index, Adjusted Rand Index or Jaccard Index). 
Note: uses/requires package \href{https://CRAN.R-project.org/package=flexclust}{flexclust}
Methods so far available (via flexclust): "ARI" .. adjusted Rand Index, "RI" .. Rand index, "J" .. Jaccard, "FM" .. Fowlkes-Mallows.
}
\examples{
set.seed(2016); tab2 <- matrix(sample(1:2, size=42, replace=TRUE), ncol=7)
if(requireNamespace("flexclust")) { flexclust::comPart(tab2[1,], tab2[2,])
  flexclust::comPart(tab2[1,], tab2[3,])
  flexclust::comPart(tab2[1,], tab2[4,]) }
## via randIndFx():
  randIndFx(tab2, adjSense=FALSE)
  cor(t(tab2))
  randIndFx(tab2, adjSense=TRUE)
}
\seealso{
\code{comPart} in \code{\link[flexclust]{randIndex}}
}
